/* File: MultimarkerMeasure.h */

#ifndef __MultimarkerMeasureHapUAndTKnownHaps_h__
#define __MultimarkerMeasureHapUAndTKnownHaps_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo MultimarkerMeasure for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
class	MultimarkerMeasureHapUAndTKnownHaps: public MultimarkerMeasureHapUAndT {


private:


//protected:

//MultimarkerMeasure<TrioSample> *parentMeasures;

public:

//longLongList* fatherCountsT, *motherCountsT, * fatherCountsU, *motherCountsU;

//HeteroListPair<long long int, double>* haplotypeFreqs, *haplotypeFreqsU, *hapFreqs;

       
/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/


public:

void empty();

//	MultimarkerMeasureHapUAndTKnownHaps(MultimarkerMeasure<TrioSample>*parentMeasures);

	MultimarkerMeasureHapUAndTKnownHaps(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int gender=everyGender, int affectation=allAffectation, BayesType  Bay=MLE, float alphaBayes=0, float distance=0.0);

	
 MultimarkerMeasureHapUAndTKnownHaps(MultimarkerMeasureHapUAndTKnownHaps& source);

 MultimarkerMeasureHapUAndTKnownHaps(TrioCounters* source);

 MultimarkerMeasureHapUAndTKnownHaps();




~MultimarkerMeasureHapUAndTKnownHaps()
	{
	};

MultimarkerMeasureHapUAndTKnownHaps* clone();

MultimarkerMeasureHapUAndTKnownHaps(MultimarkerMeasureHapUAndT& source);

void set();

Pair<longLongList*>* removeSameHaplotypes(longLongList* transList, longLongList *untransList);


void setHaplotypeFreqs();

//MultimarkerMeasureHapUAndTKnownHaps* filter(SNPPos a, SNPPos b);
//double getGenericTDT (int test, IndCategory ic=parent);


//	double getStandardizedSimilarityMeasure (IndCategory ic=parent);

//	double getSignedRankTest(bool wilcoxon=true, IndCategory ic=parent);

//	double getSimilarityMeasure (IndCategory ic=parent);

//double getTest (int testType, IndCategory ic=parent);


//HeteroListPair<long long int, double>* getComposedList(longLongList *fatherHaps, longLongList* motherHaps);

//BidimensionalTable<double>* getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans);

//double getSignedTDT ();

longLongList* getHaplotypeCountsFromGenotypes(IndCategory ic, Transmission trans);

Pair<MultidimensionalTable<double>*>* getHaplotypeFreqsTab();



long long int getHap(int*gene, bool side);

MultimarkerMeasureHapUAndTKnownHaps * getPermutation ();

};  // End of class MultimarkerMeasure
/*
ostream& operator<<(ostream& out, MultimarkerMeasureHapUAndTKnownHaps& pm)
{
   out << pm.fatherCountsT <<"\n";
   out << pm.motherCountsT << "\n";
	 out << pm.fatherCountsU <<"\n";
   out << pm.motherCountsU;
   return out;
};

*/

};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




