/* File: PD.cpp */
#include "PD.h"

#ifndef __PD_cpp__
#define __PD_cpp__



namespace BIOS {



    PD::PD(FreqAndKeyVector* hapList, MultidimensionalEmptyTable<int>* haplotypeArray)
    {
        this->hapList = hapList;
        this->haplotypeArray = haplotypeArray;
    };

    PD::PD( MultidimensionalEmptyTable<int>* haplotypeArray)
    {
        this->haplotypeArray = haplotypeArray;
        this->method = 0;
        this->iterator = 0;
    };
 
  PD::~PD()
  {};
  

  intList* PD::getHaplotype(long long int key)
  {
    return haplotypeArray->getPosList(key);
  }

    intList* PD::getHaplotypeAt(long int listPosition, FreqAndKeyVector* hapList)
{  
    int haplotypeKey;
    haplotypeKey = hapList->getElement(listPosition)->second();
    return haplotypeArray->getPosList(haplotypeKey);
}
/*
  intList* PD::getHaplotype(int listPosition, FreqAndKeyVector* hapList2)
  { 
        // hapList->getElement( i )->getSecond() 
        // gives the ith key in the haplotype array
        if (hapList==NULL)
            return haplotypeArray->getPosList(hapList->getElement(listPosition)->getSecond());
        else 
            return haplotypeArray->getPosList(hapList2->getElement(listPosition)->getSecond());
  }
*/
  float PD::getBetweenDistance(int method, FreqAndKeyVector* hapList2)
  {
        switch(method){
            case METHOD_TYPE_COUNT_MUT:
               getBetweenDistanceCountMut(hapList2);
                break;
            case METHOD_TYPE_COUNT_RECOMB:
                getBetweenDistanceCountRecomb(hapList2);
                break;
            default:
                // unknown method
                return -1;
                break;
        }
    }

 float PD::getBetweenDistanceCountMut(FreqAndKeyVector* hapList2)
    {
        return 0;
    }

 float PD::getBetweenDistanceCountRecomb(FreqAndKeyVector* hapList2)
    {
        return 0;
    }


  float PD::calculate(FreqAndKeyVector* hapList)
  {
         float (PD::*m)(intList*, intList*);

        // Choose the method
        switch(this->method){
            case METHOD_TYPE_COUNT_MUT:
               //getWithinDistanceCountMut();
                m = &PD::DistanceOfPairByDiffPos;
                //return calcByIterAll( m , hapList);
                break;
            case METHOD_TYPE_COUNT_RECOMB:
                //getWithinDistanceCountRecomb();
                //m = &PD::DistanceOfPairByRecomb;
                //getWithinDistance( m );
                break;
            default:
                // unknown method
                return -1;
                break;
        }
    
    // Choose the iterators

    switch(this->iterator){
        case ITER_TYPE_ALL:
            return calcByIterAll( m , hapList);
            break;

        case ITER_TYPE_MOST_FREQ:

            return calcByIterMostFreq( m, hapList);
             break;
        
    }
    
}

    float PD::DistanceOfPairByDiffPos(intList* haplotype1, intList* haplotype2){
        int number_of_differences=0;

        //cout << "Comparing (DistanceOfPairByDiffPos) " << *haplotype1 << " and " << *haplotype2 << endl;
        // Check haplotypes have the same length
        if (haplotype1->size() != haplotype2->size()){
            printf("DistanceOfPairByDiffPos: Different haplotype sizes");           
            return -1;
        }

         //printf(" [%i ] ", haplotype1->getElement(0));

        // On each location compare the haplotype value
        for(int i=0; i<haplotype1->size();i++){
            //printf(" [%i ] ", haplotype1[i]);
            //if (haplotype1[i] != haplotype2[i])
            if (haplotype1->getElement(i) != haplotype2->getElement(i))
                number_of_differences++;
        }
    
        //cout << "Total number of differences: " << number_of_differences << endl;
        return (float)number_of_differences / haplotype1->size();

    }

float PD::calcByIterAll( float (PD::*distance_function)(intList*, intList*) , FreqAndKeyVector* hapList)
{
       //  Sum of distance between pairs
        float total_distance = 0;
        // Pair of haplotypes to compare
        intList *haplotype1;
        intList * haplotype2; 
        // Key of  the haplotypes in the table for mapping keys and halotypes
        int haplotypeKey1, haplotypeKey2;
        // Freqs of the haplotypes
        float haplotype_freq_1, haplotype_freq_2;
        // Comparisons performed
        int total_number_of_comparisons=0;

	float one_pair_distance=0.0; // Distance by two simple haplotypes
	float one_pair_distance_times_freq=0.0; // Distance multiplied by the frequencies

/*
	for ( int jj=0; jj< hapList->size(); jj++){
		cout << hapList->getElement(jj)->getSecond() << ", ";	
	}
*/
        // Extract pairs of haplotypes. Only the ones that have not been compared
        for(int i=0; i < hapList->size(); i++){

            // First haplotype to compare
            haplotypeKey1 = hapList->getElement(i)->second();
            haplotype_freq_1 = hapList->getElement(i)->first();
            haplotype1 = getHaplotype(haplotypeKey1);
            
            for(int j=i+1; j < hapList->size(); j++){
                  //haplotype1 = getHaplotypeAt(i, hapList);

                  // Second haplotype to compare
                  haplotypeKey2 = hapList->getElement(j)->second();
                  haplotype_freq_2 = hapList->getElement(j)->first();
                  haplotype2 = getHaplotype(haplotypeKey2);

                  // For each haplotypes pair calculate distance using the given function
                  one_pair_distance = (this->*distance_function)(haplotype1, haplotype2);
		      one_pair_distance_times_freq = one_pair_distance * (haplotype_freq_1 * haplotype_freq_2);
		      total_distance += one_pair_distance_times_freq;
		    //  if ( i < 3 && j < 3) 
		    //  cout << "Distance (" << haplotypeKey1 << ", " << haplotypeKey2 << ") = " << one_pair_distance << endl;
                  //cout << "Haplotypes: " << *haplotype1 << *haplotype2<< endl;
		

                // Add comparisons to the counter
                //
                total_number_of_comparisons +=  (int)(haplotype_freq_1 * haplotype_freq_2);
                
               // if (total_distance > 0)
                    //printf("total_distance between %i and %i: %f \n", i, j, total_distance);
            }     
		total_number_of_comparisons += (int)(haplotype_freq_1*(haplotype_freq_1-1.0f)/2.0f); // Comparisons with the same haplotype, all equal to 0
	}

    //float n=(float)hapList->size();
    //float denominator = n*(n-1.0f)/2.0f;  // Number of comparisons
//	cout << "Total number of coparisons: " << total_number_of_comparisons << endl;

    if (total_number_of_comparisons > 0 )        
        return total_distance / (float)total_number_of_comparisons;
    else
        return 0.0f;

//printf("hapList->size = %i\n", hapList->size());
}

/*_____________________________________________________________________________________________________________*/

float PD::calcByIterMostFreq( float (PD::*distance_function)(intList*, intList*) , FreqAndKeyVector* hapList)
{
       //  Sum of distance between pairs
        float total_distance = 0;
        // Pair of haplotypes to compare
        intList *haplotype1; 
        intList *haplotype2;
        int haplotypeKey1, haplotypeKey2;
        float haplotype_freq_2;
        float total_number_of_haplotypes = 0; // Number of haplotypes, including repetition

    // Get the most frequent haplotype (MFH)
    int most_freq_haplotype;
   most_freq_haplotype = get_most_freq_haplotype(hapList);
   haplotypeKey1 = hapList->getElement(most_freq_haplotype)->second();
    haplotype1 = getHaplotype(haplotypeKey1);

    // Pair up (MFH) with the rest of haplotypes in the list
    for(int i=0; i < hapList->size(); i++){
                haplotype_freq_2 = hapList->getElement(i)->first();
                haplotypeKey2 = hapList->getElement(i)->second();
                haplotype2 = getHaplotype(haplotypeKey2);      
                //haplotype2 = getHaplotypeAt(i, hapList);
                // Calculate distance by using the given method 
                total_distance += (this->*distance_function)(haplotype1, haplotype2) * haplotype_freq_2; 
                
                total_number_of_haplotypes += haplotype_freq_2;

    }


    return total_distance / (float)total_number_of_haplotypes;
}

/*_____________________________________________________________________________________________________________*/

int  PD::get_most_freq_haplotype( FreqAndKeyVector* hapList )
{
return hapList->getFirstElement()->second();

}
/*_____________________________________________________________________________________________________________*/


  float PD::getWithinDistance(int method)
  {
         float (PD::*m)(intList*, intList*);
        switch(method){
            case METHOD_TYPE_COUNT_MUT:
               //getWithinDistanceCountMut();
                m = &PD::DistanceOfPairByDiffPos;
                return getWithinDistance( m );
                break;
            case METHOD_TYPE_COUNT_RECOMB:
                //getWithinDistanceCountRecomb();
                m = &PD::DistanceOfPairByRecomb;
                getWithinDistance( m );
                break;
            default:
                // unknown method
                return -1;
                break;
        }
}




float PD::getWithinDistance( float (PD::*distance_function)(intList*, intList*) )
{
       //  Sum of distance between pairs
        float total_distance = 0;
        // Pair of haplotypes to compare
        intList *haplotype1;
        intList * haplotype2; 

        // Extract pairs of haplotypes. Only the ones that have not been compared
        
        for(int i=0; i < hapList->size(); i++)
            for(int j=i; j < hapList->size(); j++){
                haplotype1 = getHaplotype(i);
                haplotype2 = getHaplotype(j);

                // For each haplotypes pair calculate distance using the given function
                total_distance += (this->*distance_function)(haplotype1, haplotype2);
                
               // if (total_distance > 0)
                    //printf("total_distance between %i and %i: %f \n", i, j, total_distance);
            }            

    return total_distance/ (float)hapList->size();

//printf("hapList->size = %i\n", hapList->size());
}


/*
 float PD::getWithinDistanceCountMut()
    {
        //  Sum of distance between pairs
        float total_distance = 0;
        // Pair of haplotypes to compare
        intList *haplotype1;
        intList * haplotype2; 

        // Extract pairs of haplotypes. Only the ones that have not been compared
        for(int i=0; i < hapList->size(); i++)
            for(int j=i; j < hapList->size(); j++){
                haplotype1 = getHaplotype(i);
                haplotype2 = getHaplotype(j);
            }            

            // For each haplotypes pair calculate distance
            total_distance += DistanceOfPairByDiffPos(haplotype1, haplotype2);
        
    }
*/


    float PD::DistanceOfPairByRecomb(intList* haplotype1, intList* haplotype2){
        int number_of_switches=0;
        enum switch_states { S_EQUAL, S_DIFFERENT }  switch_state = S_EQUAL;
/*
        // Check haplotypes have the same length
        if (haplotype1->size() != haplotype2->size()){
            printf("DistanceOfPairByDiffPos: Different haplotype sizes");
            return -1;
        }


        // On each location compare the haplotype value
        for(int i=0; i<haplotype1->size();i++){

            if (switch_state == S_EQUAL){
                if (haplotype1[i] != haplotype2[i]){
                    number_of_switches++;
                    switch_state = S_DIFFERENT;
                }
            }
            else{
                if (haplotype1[i] == haplotype2[i]){
                    number_of_switches++;
                    switch_state = S_EQUAL;
                }
            }

        }

*/
        return (float)number_of_switches;

    }
/*
 float PD::getWithinDistanceCountRecomb()
    {
        return 0;
    }
*/


  FreqAndKeyVector* PD::getHapList()
  {
    return hapList;
  };




};  // End of Namespace

#endif

/* End of file: PD.cpp */




