#ifndef __TDTtable_h__
#define __TDTtable_h__

namespace BIOS {
	
  /**
     @memo TDTtable
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author Jose Moreno
     @version 1.0
	
	*/	


class VectorOfParentalHaplotypes;

	class TDTtable: public BidimensionalTable<double>{
    
  
  private:
  
  double minFreq;
  
  bool HWE;

		public:
		//! Vector of vector of haplotypes from which the table was created
		PartitionAsSetSampleOfHaplotypes * partition;


		/**
		*	Constructor
		*/		
		TDTtable(int cols, double minFreq=0, bool HWE=false);

		/**
		*	Destructor
		*/		
		~TDTtable();

    static TDTtable* fromString(string s){throw NonImplemented("static TDTtable* fromString(string s)");};

		/**
		*	Constructor from a partition
		* 	Creates a table from the T/U data in a partition
		*	The number of columns in the table will be the number of subsets in p.
		*	The number of rows will be tow. The first for the Transmitted haplotypes. The second for the Non transmitted.
		*	@param p Partition from which to fill the table
		*/		
		TDTtable(PartitionHaplotypeTUCountsVector* hapCounts, double minFreq=0, bool HWE=false);
		
				TDTtable(TDTtable& other);

 		/**
		*	Constructor from a partition
		* 	Creates a table from the T/U data in a vector of haplotypes.
    * It creates a partition with one haplotype at each haplotypeVector in the partition
		*	The number of columns in the table will be the number of haplotypes in the vextor.
		*	The number of rows will be two. The first for the Transmitted haplotypes. The second for the Non transmitted.
		*	@param p HaplotypVector from which to fill the table
		*/		
		TDTtable(HaplotypeTUCountsVector* hapCounts, int* positions=NULL, int length=-1, double minFreq=0, bool HWE=false);

  TDTtable* clone();

  TDTtable* getFilteredTable();

  void filter();
		/**
		*	Fills the table based on the given partition.
		*	The table must have the same columns as the number of subsets in the partition 
		*	@param p Partition from which to fill the table
		*
		*/
		void Fill(PartitionHaplotypeTUCountsVector * p=NULL);


  doubleList* getHapFreqs();
  
  void update(VectorOfParentalHaplotypes* parentalHaplotypesList);
  
//	void update(HaplotypeTUCountsVector* hapCounts, int iniPos, int length, bool left);

  double getStatistic(bool HWE=false);

	
  /**
   * Statistic for TreeDT
   * @return 
   */
  double getStatisticZ();
  double getStatisticZforColumn(int i);

  double getWeightedStatistic(doubleList* weights);

//  double getPVal();

//  double getWeightedPVal(doubleList* weights);

  doubleList* getCounts(Transmission transmission);

double getTotalHomoGenotypes();

double getTotalHeteroGenotypes();

 double getHomoHapCount (int hapPos);


	double getTotalTransmissionCount(Transmission trans);

	double getHeteroHapCount(int hapPos, Transmission trans=ut);
	
	void removeSemiHomo(VectorOfParentalHaplotypes* parentalHaplotypesList);

void print();
	};


ostream& operator<<(ostream& out, TDTtable& l);



};

#endif
