#ifndef TUMLTest_cpp//
#define TUMLTest_cpp//






//using namespace UTILS;

namespace BIOS
{

  TUMLTest::TUMLTest (char* fileSample, TestModeClass *testMod, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, bool useOnlyHetero, bool testModeForInsideMeasure) :GenomeMLTest (fileSample, testMod, totalPermutations, 3, testModeForInsideMeasure) // 3 is to say that information in each sample file has to be split together in trios (trio samples)
  {
  try
  {
    this->hapExtractionConfiguration=hapExtractionConfiguration;
    this->useOnlyHetero=useOnlyHetero;
    }
catch (BasicException& be){be.addMessage("\ncalled from   TUMLTest::TUMLTest (char* fileSample, TestModeClass *testMod, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, bool useOnlyHetero) :GenomeMLTest (fileSample, testMod, totalPermutations, 3)"); throw;};
  }

  /*___________________________________________________________ */

  TUMLTest::~TUMLTest()
  {
  }
  /*___________________________________________________________ */

  GenericSample*  TUMLTest::getSample (char* file, int*pos, int length)
  {
    try
    {
      TrioSample* ts=new TrioSample (file, NULL, 0, hapExtractionConfiguration->alleleOrderType);
//print(pos, length, cout);
      VectorOfParentalGenotypes* result=ts->getGenotypeCounts (pos, length);// it only works for left/right so far
      zap (ts);
      return  result;
    }
    catch (BasicException& be) {be.addMessage ("\ncalled from GenericSample*  TUMLTest::getSample(char* file, int* pos, int size) "); throw;};
  }

  /*___________________________________________________________ */

  GenericCounts*  TUMLTest::getCounts (GenericSample* ts, int* pos, int size)
  {
    try
    {
      GenericCounts* results= ( (VectorOfParentalGenotypes*) ts)->getTUCounts (hapExtractionConfiguration, totalPermutations, pos, size);
      
      
      //cout <<"WWWW\n00000: \n" << *new TDTtable(((TUCounts*)results)->haplotypeTUCountsVector, NULL, 0, 0);
      /*
      cout <<"before remove\n";
      for(int x = 0; x < 120000; x++)
          for(int y = 0; y < 20000; y++);
          zap(results);
          cout <<"after remov:\n";
          for(int x = 0; x < 120000; x++)
          for(int y = 0; y < 20000; y++);
          exit(0);
          */
      return results;
    }
    catch (BasicException& be) {be.addMessage ("\ncalled from  GenericCounts*  TUMLTest::getCounts(char* file, int* pos, int size)"); throw;};
  }
} // end namespace
#endif
