#ifndef __Chi2TDTMeasure_h__
#define __Chi2TDTMeasure_h__

namespace BIOS {
	
  /**
     @memo Chi2TDTMeasure
     @doc
     Definition:
	  Abstract class generalizing all Chi2-based TDT measures

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class Chi2TDTMeasure: public SimpleTUMeasure {
    
protected:
  
  TDTtable* tdtTable;

  //int minFreq;
  

		public:
	

		/**
		*	Constructor
		*/		
	//	Chi2TDTMeasure(bool permutations=false);

		/**
		*	Destructor
		*/		
	virtual	~Chi2TDTMeasure();

 // virtual GenericMeasure* getNewMeasure(TUCounts* tuCounts)=0;


		/**
		*	Constructor 
		*	@param tuCounts Hapcounts to be used
		*/		
		Chi2TDTMeasure(TUCounts* tuCounts, double minFreq=0, bool permutations=false, bool left=true);

		Chi2TDTMeasure(double minFreq=0, bool permutations=false, bool left=true);
		
		//virtual Chi2TDTMeasure* getNewMeasure(TUCounts* tuCounts)=0;

		virtual Chi2TDTMeasure* inferMeasure(TUCounts* tuCounts);

		Chi2TDTMeasure(Chi2TDTMeasure& other);

//virtual Chi2TDTMeasure* clone();

		/**
		*	Calculate statistic from the tables 
		*/



  //virtual stringList* getFreqsResults();

//virtual string getName();

	virtual double getStatistic();

	double getWeightedStatistic(doubleList* weights);

	doubleList* getHapFreqs();

// virtual double getPValWithPermutations();

 virtual double getPVal();


 TDTtable* getTDTtable();

//virtual stringList* getFreqsResults();

virtual stringList*  getHeadFile();


//friend ostream& operator<<(ostream& out, Chi2TDTMeasure& l);

virtual void print( ostream&);

};
/*{
out << (TUMeasure&)l <<"\n";

out << *l.getTDTtable() <<"\n";
}
*/

};

#endif
