#ifndef __CompositeTUMeasure_cpp__
#define __CompositeTUMeasure_cpp__


namespace BIOS {

	CompositeTUMeasure::CompositeTUMeasure(CompositeTUMeasure & other)
	{
		this->measureLeft = other.measureLeft->clone();		
		this->measureRight = other.measureRight->clone();	

		this->measureLeft->tuCounts = other.measureLeft->tuCounts->clone();
		this->measureRight->tuCounts = other.measureRight->tuCounts->clone();
	}

	CompositeTUMeasure::CompositeTUMeasure(TUMeasure *  measureLeft, TUMeasure *measureRight,  double minFreq)
	{
		this->measureLeft = measureLeft;
		this->measureRight = measureRight;
	};

	CompositeTUMeasure::CompositeTUMeasure(TUCounts* tuCounts, TUMeasure *  measureLeft, TUMeasure *measureRight,  double minFreq):TUMeasure(tuCounts)
	{

		if ( tuCounts == NULL) 
			throw null_tuCounts;

		this->tuCounts = tuCounts;

		this->measureLeft = measureLeft;
		this->measureRight = measureRight;

		this->measureLeft->setTUCounts( tuCounts->filterLeftHalf() );
		this->measureRight->setTUCounts( tuCounts->filterRightHalf() );

	};


	CompositeTUMeasure::~CompositeTUMeasure()
	{
		if (measureLeft->tuCounts != NULL)
			delete measureLeft->tuCounts;
		if (measureRight->tuCounts != NULL)
			delete measureRight->tuCounts;
		delete measureLeft;
		delete measureRight;
		
	}


	double CompositeTUMeasure::getPVal()
	{
		double p_right, p_left;
		
		p_right = measureRight->getPVal();
		p_left = measureLeft->getPVal();

		return p_right * p_left;


	}

	string CompositeTUMeasure::getName(){
		return string("TDTComposite("  + measureLeft->getName() + ", " + measureRight->getName() + ")" );
	};
	
	CompositeTUMeasure* CompositeTUMeasure::clone(){
 		return new CompositeTUMeasure(*this);
	};

	CompositeTUMeasure* CompositeTUMeasure::getNewMeasure(TUCounts* tuCounts)
	{
		return new CompositeTUMeasure(tuCounts, measureLeft, measureRight, minFreq);
	};

	CompositeTUMeasure* CompositeTUMeasure::inferMeasure(TUCounts* tuCounts)
	{
		TUCounts * tuLeft = tuCounts->filterLeftHalf();
		TUCounts * tuRight = tuCounts->filterRightHalf();

		CompositeTUMeasure * compositeMeasure = new CompositeTUMeasure(measureLeft->inferMeasure(tuLeft), measureRight->inferMeasure(tuRight), minFreq);
		compositeMeasure->tuCounts = tuCounts;

		return compositeMeasure;
		
	};
	
};

#endif
