#ifndef __EntropyTDTMeasure_cpp__
#define __EntropyTDTMeasure_cpp__

#include "EntropyTDTMeasure.h"



namespace BIOS {

		EntropyTDTMeasure::EntropyTDTMeasure(TUCounts* tuCounts, double minFreq, bool permutations, bool left):Chi2TDTMeasure(tuCounts, minFreq, permutations, left)
{
		};

/*_________________________________________________________________*/

		EntropyTDTMeasure::EntropyTDTMeasure(double minFreq, bool permutations, bool left):Chi2TDTMeasure(minFreq, permutations, left)
{
		};

/*_________________________________________________________________*/

		EntropyTDTMeasure::EntropyTDTMeasure(EntropyTDTMeasure& other):Chi2TDTMeasure(other)
{
		};

/*_________________________________________________________________*/

		EntropyTDTMeasure::~EntropyTDTMeasure(){
		};
		
			/*___________________________________________________________________________________*/
 
 
 string EntropyTDTMeasure::getName()
 {
 string result=string("EntropyTDT");
 if (minFreq!=0) result=result+string("_minFreq")+tos(minFreq);
 if (permutations) result=result+addPermutationsInName();
 return result;
 };

/*_________________________________________________________________*/

  EntropyTDTMeasure* EntropyTDTMeasure::getNewMeasure(TUCounts* tuCounts)
{
return new EntropyTDTMeasure(tuCounts, minFreq, permutations);
}

/*_________________________________________________________________*/

		EntropyTDTMeasure* EntropyTDTMeasure::clone(){
  return new EntropyTDTMeasure(*this);
		};


/*_______________________________________________________________________________*/


		double EntropyTDTMeasure::getStatistic()
		{
double condT, condU, tCounts, uCounts, ni, result=0;
if (tdtTable==NULL) return 0;
for (int i=0; i<tdtTable->getYDim(); i++)
{
tCounts=tdtTable->getValue(0,i);
uCounts=tdtTable->getValue(1,i);
ni=tCounts+uCounts; 
condT=tCounts/(double)ni; 
condU=uCounts/(double)ni;  
if (condT!=0 && condU!=0)
result+=ni*std::pow(condT*log(condT)-condU*log(condU), 2)/(condT*condU*std::pow(2+log(condT)+log(condU),2)); 
else  result+ni;
}
return result*(tdtTable->getYDim()-1)/(double)tdtTable->getYDim();
		};

/*_____________________________________________________________________________________________________________*/






/*_____________________________________________________________*/

	double EntropyTDTMeasure::getPVal()
  {
if (!permutations) 
if (tdtTable!=NULL) return pdfTestChiSquare(getStatistic(),tdtTable->getYDim()-1);
else return 1;
else return SimpleTUMeasure::getPVal(); 
  }


};

#endif
