#ifndef __G2Measure_cpp__
#define __G2Measure_cpp__




/*_____________________________________________________________*/

void print(BIOS::G2Measure *t){
	cout << *t << endl;
}


/*_____________________________________________________________*/


namespace BIOS {

		G2Measure::G2Measure(TUCounts* tuCounts, double minFreq, int testMode, int fold, TUCounts** partialTuCountsTraning, TUCounts** partialTuCountsTest, bool left):GroupBasedTDTMeasure(tuCounts, minFreq, testMode, fold, partialTuCountsTraning, partialTuCountsTest, false, left)
{
try
{
  totalMultipleTest=0;
  if (testMode==1 && tdtTable!=NULL && tdtTable->partition!=NULL) totalMultipleTest=std::pow(2,(double)tdtTable->partition->size()-1)-1;
  
   setAll();
   }
  catch (BasicException& be) {be.addMessage ("\ncalled from G2Measure::G2Measure(TUCounts* tuCounts, double minFreq, bool left)"); throw;};
		};

			/*_____________________________________________________________*/

	TDTtable* G2Measure::set(TUCounts* aTUCounts)
	{
	try
	{
TDTtable* result;  
    if (aTUCounts!=NULL)
    {
				PartitionHaplotypeTUCountsVector* p=new PartitionHaplotypeTUCountsVector();
    p->insertElement(new HaplotypeTUCountsVector());
    p->insertElement(new HaplotypeTUCountsVector());
			double sumT1=0, sumT2=0, sumU1=0, sumU2=0;
   HaplotypeTUCounts* h;
			for(HaplotypeTUCountsVector::iterator it=aTUCounts->haplotypeTUCountsVector->begin(); it!=aTUCounts->haplotypeTUCountsVector->end();it++)
   {
    h=aTUCounts->haplotypeTUCountsVector->getElement(it);			
    if (((h->frequencyT+h->frequencyU))>=minFreq)
{

if (h->frequencyT>h->frequencyU) p->getElement(0)->insertHardElement(h);
if (h->frequencyT<h->frequencyU) p->getElement(1)->insertHardElement(h);
if (h->frequencyT==h->frequencyU) p->getElement(rand()%2)->insertHardElement(h);

//p->getElement(rand()%2)->insertHardElement(h);
 }
   }
   result=new TDTtable(p); 
   zap(p);
   return result;
    }
      }
  catch (BasicException& be) {be.addMessage ("\ncalled from G2Measure::set()"); throw;};
	}

		/*_____________________________________________________________*/

		G2Measure::G2Measure(double minFreq, int testMode, int fold, bool left):GroupBasedTDTMeasure(minFreq, testMode, fold, false, left)
		{
totalMultipleTest=0;
		}

		
		/*_____________________________________________________________*/

		G2Measure::G2Measure(G2Measure& other):GroupBasedTDTMeasure(other)
		{
totalMultipleTest=other.totalMultipleTest;
		}

/*________________________________________________________________________________*/
/*
		double G2Measure::getStatistic()
		{
		return Chi2TDTMeasure::getStatistic()/2;
		}
		/*
		double sum;
		if (tdtTable==NULL) 
		{
		//cout <<"nulltable\n";
		return 0;
		}
		if (tdtTable->getYDim()!=2) 
		{
		cout <<" table 2G is:" << *tdtTable <<"\n";
		throw BadFormat("double G2Measure::getStatistic()");
		}
		sum=std::pow(tdtTable->getValue(0,0)-tdtTable->getValue(1,0),2);
	 sum=sum/min(tdtTable->getHeteroHapCount (0, ut), tdtTable->getHeteroHapCount(1, ut));
	 if (tuCounts->getTotalPos()==1 && Chi2TDTMeasure::getStatistic()!=sum)
	 {
	 	 		cout <<" table 2G is:" << *tdtTable <<"\n";
	 	 		cout <<" statistic is: " << sum <<"\n";
	 	 		cout <<" while statistic for Chi2 is:" << Chi2TDTMeasure::getStatistic() <<"\n";
	 	 throw BadFormat("	double G2Measure::getStatistic()");
	 }
			};

/*_________________________________________________________________*/

  G2Measure* G2Measure::getNewMeasure(TUCounts* tuCounts, TUCounts** training, TUCounts** test)
{
try
{
return new G2Measure(tuCounts, minFreq, testMode, fold, training, test);
}
  catch (BasicException& be) {be.addMessage ("\ncalled from G2Measure* G2Measure::getNewMeasure(TUCounts* tuCounts)"); throw;};
}

/*_________________________________________________________________*/
/*
  G2Measure* G2Measure::inferMeasure(TUCounts* tuCounts)
{
return new G2Measure(tuCounts, minFreq);
}
/*____________________________________________________________________________*/


		G2Measure::~G2Measure(){
		};

/*____________________________________________________________________________*/


	G2Measure*	G2Measure::clone(){
 return new G2Measure(*this);		
};

/*____________________________________________________________________________*/

 string G2Measure::getName()
 {
 string result=string("mTDT2G");
 if (testMode==1) result=result+string("_Bonferroni");
 if (testMode==2) result=result+string("_cv")+tos(fold);
 if (minFreq!=0) result=result+string("_minFreq")+tos(minFreq);
 //if (permutations) result=result+string("_")+tos(tuCounts->getTotalPermutations())+string("permutations");
return result;
}
/*_________________________________________________________________*/

stringList*  G2Measure::getHeadFile()
 {
stringList *result=new stringList();
result->insertElement(string("FirstSNP"));
result->insertElement(string("pVal "));
result->insertElement(string("TotalUsedDifferentHaplotypesInG1 // "));
result->insertElement(string("T/U G1 // "));
result->insertElement(string("TotalUsedDifferenteHaplotypesInG2 //"));
result->insertElement(string("T/U G2"));
return result;
};


/*_____________________________________________________________*/

/*
	double G2Measure::getPVal()
  {
  try
{
int minDF;
double result;
if (tdtTable==NULL) return 1;
if (permutations) return SimpleTUMeasure::getPVal();
minDF=2;
if (totalUsedDifferentHaplotypes==2 && fold==2) minDF=1;
//minDF=min(minDF, tuCounts->getParentalGenotypes()->size()/fold);
//if (minDF==0) throw ZeroValue("double G2Measure::getPVal()");
result=pdfTestChiSquare(getStatistic(),minDF);
//result=pdfTestChiSquare(getStatistic(),2);
if (isNAN(result)) 
{
cout << *tdtTable <<"\n";
cout <<"totalheteros:" << tdtTable->getTotalHeteroGenotypes()<<"\n";
cout << "statistic is: " << getStatistic();
throw NanValue(" Chi2TDTMeasure::getPVal()");
}
return result;
}
catch (BasicException& be) {be.addMessage ("\ncalled from G2Measure::getPVal()"); throw;};

  }

/*_____________________________________________________________________________________________________________*/


void G2Measure::onePrint(ostream& out, TUCounts* aTuCounts, TDTtable* aTDTtable)
{
out << aTuCounts->getParentalGenotypes()->getPositions()[aTuCounts->getPositions()[0]] <<"\t";
if (aTDTtable!=NULL)
{
for (int i=1; i<3; i++)
{
aTDTtable->partition->getElement(i-1)->setDelimiters('\0', '\0');
//if (i==2) out <<"\n";
out << getPVal() << "\t";
out << "G" << i <<":\t" << *aTDTtable->partition->getElement(i-1);
out <<"\tT:\t" << aTDTtable->getValue(0,i-1) << "\tU: \t" << aTDTtable->getValue(1,i-1);
if (i==1) out <<"\t";
aTDTtable->partition->getElement(i-1)->setDelimiters('[', ']');
}
}
else out <<"nullTable\n\n\n";

};

}
#endif
