#ifndef __GroupBasedTDTMeasure_cpp__
#define __GroupBasedTDTMeasure_cpp__




namespace BIOS {



		GroupBasedTDTMeasure::GroupBasedTDTMeasure(TUCounts* tuCounts, double minFreq, int testMode, int fold, TUCounts** partialTuCountsTraining, TUCounts** partialTuCountsTest, bool permutations, bool left):Chi2TDTMeasure(tuCounts, minFreq, permutations, left)
{
totalMultipleTest=0;
this->testMode=testMode;
this->fold=fold;
this->partialTuCountsTraining=partialTuCountsTraining;
this->partialTuCountsTest=partialTuCountsTest;
partialTdtTables=NULL;
totalUsedHaplotypes=0;
totalUsedDifferentHaplotypes=0;
if (tdtTable!=NULL) 
{
//cout << "initableis:" << *tdtTable <<"\n";
totalUsedHaplotypes=(int)tdtTable->getTotalTransmissionCount (ut);
totalUsedDifferentHaplotypes=tdtTable->getYDim();
}
//parentalHaplotypesListAdhoc=NULL;
};

/*_________________________________________________________________*/

		GroupBasedTDTMeasure::GroupBasedTDTMeasure(double minFreq, int testMode, int fold, bool permutations, bool left):Chi2TDTMeasure(minFreq, permutations, left)
{
totalMultipleTest=0;
totalUsedHaplotypes=0;
totalUsedDifferentHaplotypes=0;
this->testMode=testMode;
this->fold=fold;
partialTdtTables=NULL;
partialTuCountsTraining=NULL;
partialTuCountsTest=NULL;
//parentalHaplotypesListAdhoc=NULL;
		};



		
		/*_________________________________________________________________*/

		GroupBasedTDTMeasure::GroupBasedTDTMeasure(GroupBasedTDTMeasure& other):Chi2TDTMeasure(other){
totalMultipleTest=other.totalMultipleTest;
testMode=other.testMode;
fold=other.fold;
partialTuCountsTraining=other.partialTuCountsTraining;
partialTuCountsTest=other.partialTuCountsTest;
partialTdtTables=NULL;
totalUsedHaplotypes=other.totalUsedHaplotypes;
totalUsedDifferentHaplotypes=other.totalUsedDifferentHaplotypes;
if (testMode==2 && other.partialTdtTables!=NULL) partialTdtTables=other.partialTdtTables->clone();
//parentalHaplotypesListAdhoc=NULL;
//if (other.parentalHaplotypesListAdhoc!=NULL) parentalHaplotypesListAdhoc=other.parentalHaplotypesListAdhoc->clone();
		};
		


/*_________________________________________________________________*/

		GroupBasedTDTMeasure::~GroupBasedTDTMeasure(){
  //zap(tdtTable);
  if (testMode==2) zap(partialTdtTables);
  //zap(parentalHaplotypesListAdhoc);
		};
		
		/*_________________________________________________________________*/

		void GroupBasedTDTMeasure::removeSemiHomo()
		{
		//.........
		try
		{
		if (tdtTable!=NULL && tuCounts!=NULL)
				tdtTable->removeSemiHomo(tuCounts->parentalHaplotypesList);
			}
  catch (BasicException& be) {be.addMessage ("\ncalled from void GroupBasedTDTMeasure::removeSemiHomo()2"); throw;};
		};

		
		/*_________________________________________________________________*/

		void GroupBasedTDTMeasure::setAll()
		{
		//.........
		try
		{
		TDTtable* aTdtTable;
zap(tdtTable);		
if (testMode!=2) 
{
tdtTable=set(tuCounts);
removeSemiHomo();
return;
}
partialTdtTables=new TDTtableVector();
//parentalHaplotypesListAdhoc=new VectorOfParentalHaplotypes(tuCounts->parentalHaplotypesList->getPositions(), tuCounts->parentalHaplotypesList->getLength());
//cout <<"fold is: " << fold <<"\n";
for (int i=0; i<fold; i++)
{
if (partialTuCountsTraining[i]==NULL) throw NullValue("void GroupBasedTDTMeasure::setAll()");
//cout <<* partialTuCountsTraining[i] <<"\n";
aTdtTable=set(partialTuCountsTraining[i]);

//cout <<"partial:" << *partialTuCountsTraining[i]->parentalHaplotypesList <<"beforeremoving\n";
//cout <<"partial:" << *aTdtTable <<"beforeremoving\n";
//if (aTdtTable!=NULL) aTdtTable->removeSemiHomo(partialTuCountsTraining[i]->parentalHaplotypesList);
if (partialTuCountsTest[i]==NULL) throw NullValue("void GroupBasedTDTMeasure::setAll()");
if (aTdtTable!=NULL) 
{
aTdtTable->update(partialTuCountsTest[i]->parentalHaplotypesList);
if (aTdtTable!=NULL && aTdtTable->partition==NULL) zap(aTdtTable);
if (aTdtTable!=NULL) 
{
partialTdtTables->insertElement(aTdtTable);
//parentalHaplotypesListAdhoc->copyPaste(partialTuCountsTest[i]->parentalHaplotypesList);
}
//cout <<"BEE:\n" << *this <<"\n";
}
}
//cout <<"tables are:" << *partialTdtTables <<"\n";
//cout <<"first is:" << *partialTuCountsTest[0]->parentalHaplotypesList <<"\nend\n";
//cout <<"adhoc is:" << *parentalHaplotypesListAdhoc <<"\n";
//cout <<"clone:" << *partialTuCountsTest[0]->parentalHaplotypesList->clone() <<"\nend\n";
//parentalHaplotypesListAdhoc->copyPaste(partialTuCountsTest[0]->parentalHaplotypesList);

//		cout <<"\nbemmmmrem: \n" << *this <<"\n";

//removeSemiHomo();
setFinal();
}
catch (BasicException& be) {be.addMessage ("\ncalled from void GroupBasedTDTMeasure::setAll()"); throw;};
};

		
		/*_________________________________________________________________*/

		void GroupBasedTDTMeasure::setFinal()
		{
		//.........
		try
		{
		
	//	cout <<"\nbemmmmfris: \n" << *this <<"\n";
		
		
		TDTtable* aTDTtable;
		if (partialTdtTables->size()==0) return;
tdtTable=new TDTtable(2);
Haplotype * h;
int position;


for(int i=0;i<partialTdtTables->size(); i++)
{
aTDTtable=partialTdtTables->getElement(i);
if (i==0) tdtTable->partition=aTDTtable->partition->clone();
//cout <<"partition is:" << *aTDTtable->partition <<", while clone is:" << *tdtTable->partition <<"\n";
else 
for (PartitionAsSetSampleOfHaplotypes::iterator it=aTDTtable->partition->begin(); it!=aTDTtable->partition->end(); it++)
for (HaplotypeSet::iterator it2=aTDTtable->partition->getElement(it)->begin(); it2!=aTDTtable->partition->getElement(it)->end(); it2++)
{
h=aTDTtable->partition->getElement(it)->getElement(it2);
position=aTDTtable->partition->getPosition(it);
if (tdtTable->partition->getElement(position)->findEqualElement(h)==tdtTable->partition->getElement(position)->end())
tdtTable->partition->getElement(position)->insertHardElement(h);
}
//cout <<"current partition is:" << *aTDTtable->partition <<", while tdt is:" << *tdtTable->partition <<"\n";

for (int j=0; j<aTDTtable->getYDim(); j++)
for (int k=0; k<aTDTtable->getXDim(); k++)
 tdtTable->addValue(k,j, aTDTtable->getValue(k,j));
}
//cout <<"\nbefris: \n" << *this <<"\n";
//cout <<"partition is now:" << *tdtTable->partition <<"\n";
//cout <<"adhoc is:" << *parentalHaplotypesListAdhoc <<"\n";
//tdtTable->update(parentalHaplotypesListAdhoc);
//cout <<"\nafter is: \n" <<* this <<"\n";

//zap(tdtTable);
//tdtTable=set(tuCounts);
//removeSemiHomo();

//cout <<"\nafterafter is: \n" <<* this <<"\n";

//exit (0);


}
catch (BasicException& be) {be.addMessage ("\ncalled from void GroupBasedTDTMeasure::setAll()"); throw;};
};


/*_____________________________________________________________*/


	double GroupBasedTDTMeasure::getPVal()
  {
  try
{
int minDF;
double result;
if (partialTdtTables==NULL || partialTdtTables->size()==0) return Chi2TDTMeasure::getPVal();

minDF=2;
if (totalUsedDifferentHaplotypes==2 && fold==2) minDF=1;
//minDF=min(minDF, tuCounts->getParentalGenotypes()->size()/fold);
//if (minDF==0) throw ZeroValue("double G2Measure::getPVal()");
result=pdfTestChiSquare(getStatistic(),fold);
//result=pdfTestChiSquare(getStatistic(),2);
if (isNAN(result)) 
{
cout << *tdtTable <<"\n";
cout <<"totalheteros:" << tdtTable->getTotalHeteroGenotypes()<<"\n";
cout << "statistic is: " << getStatistic();
throw NanValue(" Chi2TDTMeasure::getPVal()");
}
return result;
}
catch (BasicException& be) {be.addMessage ("\ncalled from GroupBasedTDTMeasure::getPVal()"); throw;};

  }
/*_________________________________________________________________*/

  double GroupBasedTDTMeasure::getTotalMultipleTest()
  {
    return totalMultipleTest;
  };
  
  
/*_________________________________________________________________*/

  void GroupBasedTDTMeasure::print(ostream& out)
  {
	onePrint(out, tuCounts, tdtTable);
	if (testMode==2 && partialTdtTables!=NULL)
	for (int i=0; i<partialTdtTables->size(); i++)
	{
	 out <<"\n";
	 onePrint(out, partialTuCountsTest[i], partialTdtTables->getElement(i));
	 }
  };

		
/*_________________________________________________________________________________________________*/
		
double GroupBasedTDTMeasure::getStatistic()
{
double result=0;
if (partialTdtTables==NULL || partialTdtTables->size()==0) return Chi2TDTMeasure::getStatistic();
for (TDTtableVector::iterator it=partialTdtTables->begin(); it<partialTdtTables->end(); it++)
result=result+partialTdtTables->getElement(it)->getStatistic();
return result; //partialTdtTables->size();
}    
    /*_________________________________________________________________________________________________*/


/*_____________________________________________________________________________________________________________*/

/*
		ostream& GroupBasedTDTMeasure::print(ostream& out){
   out << *this;
   return out;
		};
/*_____________________________________________________________*/


};

#endif
