#ifndef __LaplaceTDTMeasure_cpp__
#define __LaplaceTDTMeasure_cpp__




/*_____________________________________________________________*/

void print(BIOS::LaplaceTDTMeasure *t){
	cout << *t << endl;
}


/*_____________________________________________________________*/


namespace BIOS {		


LaplaceTDTMeasure::LaplaceTDTMeasure(TUCounts* tuCounts, double alpha, bool left):Chi2TDTMeasure (tuCounts, 0, false, left)
{
this->alpha=alpha;;
		};

/*___________________________________________________________________*/


LaplaceTDTMeasure::LaplaceTDTMeasure(double alpha, bool left):Chi2TDTMeasure (0, false, left)
{
this->alpha=alpha;;
		};

/*___________________________________________________________________*/

LaplaceTDTMeasure* LaplaceTDTMeasure::clone()
{
return new LaplaceTDTMeasure(*this);
		};

/*_________________________________________________________________________*/

		LaplaceTDTMeasure::~LaplaceTDTMeasure(){
		 zap(tdtTable);
			}


/*___________________________________________________________________*/

LaplaceTDTMeasure* LaplaceTDTMeasure::getNewMeasure(TUCounts* tuCounts, TUCounts** training, TUCounts** test)
{
return new LaplaceTDTMeasure(tuCounts, alpha);
		};
/*_____________________________________________________________________________*/


		double LaplaceTDTMeasure::getStatistic()
		{
  if (tdtTable==NULL) return MAXINT;
      int k=tdtTable->getYDim();
						double result=0, a, b;
      for (int i=0; i<tdtTable->getYDim(); i++)
						{
								a=tdtTable->getValue(0,i);
								b=tdtTable->getValue(1,i);
        if ((a+b)==0) throw ZeroValue("LaplaceTDTMeasure::getStatistic()"); 
        result+=std::pow(a-b,2)/(double)(a+b+alpha);
      }
     return result*(k-1)/(double)k;
		};

/*______________________________________________________________________*/


		string LaplaceTDTMeasure::getName()
{
return string("mTDTLaplaceAlpha_")+tos(alpha);
};

/*_____________________________________________________________________________________________________________*/




/*_________________________________________________________________*/

stringList* LaplaceTDTMeasure::getFreqsResults()
 {
throw NonImplemented("aplaceTDTMeasure::getFreqsResults()");
/*
doubleList*r;
stringList* result=new stringList();
result->insertElement(tos(tuCounts->getTrioCounters()->pos[0]));
 result->insertElement(string("Haplotypes: "));
 result->insertElement((tos(tdtTable->partition)));
 result->insertElement(string("\nT: ")); 
 r=tdtTable->getCounts(1);
 result->insertElement(tos(r));
 zap(r);
 result->insertElement(string("\nU: ")); 
 r=tdtTable->getCounts(0);
 result->insertElement(tos(r));
 zap(r);
return result;
*/
}


	
};

#endif
