#ifndef __LengthContrastMeasure_h__
#define __LengthContrastMeasure_h__

namespace BIOS {
	
  /**
     @memo LengthContrastMeasure
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class LengthContrastMeasure: public SimpleTUMeasure {
    
		public:
	

Container<vector<Pair<double>*>, Pair<double> *>* DList;

double measure;

double totalCounts;

		/**
		*	Constructor
		*/		
	//	LengthContrastMeasure();

		/**
		*	Destructor
		*/		
	virtual	~LengthContrastMeasure();

virtual LengthContrastMeasure* clone();

 void setStatistic();
 
  virtual double getStatistic();

 virtual  LengthContrastMeasure* getNewMeasure(TUCounts* tuCounts, TUCounts** training=NULL, TUCounts** test=NULL);
 
  virtual  LengthContrastMeasure* inferMeasure(TUCounts* tuCounts);

		/**
		*	Constructor 
		*	@param minFreq Min number of counts in an haplotype to be used
		*/		
		LengthContrastMeasure(TUCounts* tuCounts, bool left=true);

		LengthContrastMeasure(bool left=true);
		
				LengthContrastMeasure(LengthContrastMeasure& other);

double getLengthMeasure (base* p1T, base* p2T, base* p1U, base* p2U); 


  virtual stringList* getHeadFile();

 virtual string getName();//{return string("mTDT1T");};
		/**
		*	Calculate statistic from the tables 
		*/

//	double getStatistic();

//	double getPVal();

virtual void print(ostream&);

//friend ostream& operator<<(ostream& out, LaplaceTDTMeasure& l){};



	};



};

#endif
