#ifndef __SignedRankMeasure_cpp__
#define __SignedRankMeasure_cpp__




/*_____________________________________________________________*/

void print(BIOS::SignedRankMeasure *t){
	cout << *t << endl;
}


/*_____________________________________________________________*/


namespace BIOS {

SignedRankMeasure::SignedRankMeasure(TUCounts* tuCounts, bool Wilcoxon, bool left):LengthContrastMeasure (tuCounts, left)
{
this->Wilcoxon=Wilcoxon;
};

		/*______________________________________________________________________________________*/

SignedRankMeasure::SignedRankMeasure(bool Wilcoxon, bool left):LengthContrastMeasure (left)
{
this->Wilcoxon=Wilcoxon;
};

		/*______________________________________________________________________________________*/

		SignedRankMeasure::SignedRankMeasure(LengthContrastMeasure& other, bool Wilcoxon):LengthContrastMeasure (other)
{
this->Wilcoxon=Wilcoxon;
		};
		
				/*______________________________________________________________________________________*/

		SignedRankMeasure::SignedRankMeasure(SignedRankMeasure& other):LengthContrastMeasure (other)
{
this->Wilcoxon=other.Wilcoxon;
		};

/*_________________________________________________________________*/

  SignedRankMeasure* SignedRankMeasure::getNewMeasure(TUCounts* tuCounts, TUCounts** training, TUCounts** test)
{
return new SignedRankMeasure(tuCounts, Wilcoxon);
}

/*_________________________________________________________________*/

  SignedRankMeasure* SignedRankMeasure::inferMeasure(TUCounts* tuCounts)
{
//throw NonImplemented(" SignedRankMeasure::getNewMeasure(TUCou...");
//cout <<"have to think how to keep the model\n";
return new SignedRankMeasure(tuCounts);
}


/*___________________________________________________________________________*/


		SignedRankMeasure::~SignedRankMeasure(){
			};


	string SignedRankMeasure::getName(){return string("SignedRankTest");};
/*___________________________________________________________________________*/


		SignedRankMeasure* SignedRankMeasure::clone(){
		 return new SignedRankMeasure(*this);
			};
	

/*___________________________________________________________________________________*/


double SignedRankMeasure::getStatistic()
{
double result=measure;// LengthContrastMeasure
bool onlyOne, end;
double total=0, rank=1, D;
Container<vector<Pair<double>*>, Pair<double> *>::iterator p=DList->getFirst(), pIni, p3;
int sameD=0;
double avRank=0, sigma, alpha, absD, halfComparisons=(totalCounts+1)/(double)2;
rank=1;
while (p!=DList->end())
{
absD=DList->getElement(p)->getFirst();
D=DList->getElement(p)->getSecond();
p=DList->getNext(p);
sameD=1;
avRank=rank;
pIni=p;
onlyOne=true;
while (p!=DList->end() && DList->getElement(p)->getFirst()==absD)
{
onlyOne=false;
end=false;
sameD++;
p=DList->getNext(p);
avRank=avRank+rank;
}
avRank=avRank/(double)sameD;
p3=pIni;
sigma=0;
if (Wilcoxon) alpha=avRank;
else if (avRank<=halfComparisons) alpha=0; else alpha=avRank-halfComparisons;

//cout <<"\navrank is " << avRank <<" totalCounts is:" << totalCounts <<"\n";
while ((p3!=p && !onlyOne) || (onlyOne && !end))
{
if (sameD==1) end=true;
sigma=0;
if (!onlyOne) D=DList->getElement(p3)->getSecond();
if (D>0) sigma=1; else if (D==0) sigma=0.5; 
//if (avRank>(totalCounts+1)/2) total=total+(avRank-(totalCounts+1)/2)*sigma;
total=total+alpha*sigma;
p3=DList->getNext(p3);
}
rank++;
}
return total;
};

/*_________________________________________________________________*/

		void SignedRankMeasure::print(ostream& out){
   out << "Wilcoxon: " << Wilcoxon <<  "\t";
   out << "pVal: " << getPVal() <<"\n";
		};

/*_____________________________________________________________*/

/*
	doubleList* SignedRankMeasure::getHapFreqs()
  {
  doubleList* results=new doubleList();
  for (int i=0; i<getYDim(); i++) 
   results->insertElement((getValue(0,i)+getValue(1,i))/(double)getTotalCounts());
  return results;
  }



/*_____________________________________________________________*/

/*
	double SignedRankMeasure::getPVal()
  {
  return pdfTestChiSquare(getStatistic(),getYDim()-1); 
  }

*/
	
};

#endif
