#ifndef __TDT1Measure_cpp__
#define __TDT1Measure_cpp__




/*_____________________________________________________________*/

void print(BIOS::TDT1Measure *t){
	cout << *t << endl;
}


/*_____________________________________________________________*/


namespace BIOS {

	
		TDT1Measure::TDT1Measure(int trans, double minFreq, int testMode, int fold, bool left):GroupBasedTDTMeasure (minFreq, testMode, fold, false, left)
{
if (trans<0 || trans>3) throw BadFormat("TDT1Measure::TDT1Measure(TUCounts* tuCounts, int transmission, double minFreq, bool left):GroupBasedTDTMeasure (tuCounts, minFreq, left)");
transmission=(Transmission) trans;
		};

/*______________________________________________________________________________________*/

		TDT1Measure::TDT1Measure(TDT1Measure& other):GroupBasedTDTMeasure (other)
{
transmission=other.transmission;
		};
	
/*____________________________________________________________ */

TDT1Measure::TDT1Measure(TUCounts* tuCounts, int trans, double minFreq, int testMode, int fold, TUCounts** partialTuCountsTraning, TUCounts** partialTuCountsTest, bool left): GroupBasedTDTMeasure(tuCounts, minFreq, testMode, fold, partialTuCountsTraning, partialTuCountsTest, false, left)
{
if (trans<0 || trans>3) throw BadFormat("TDT1Measure::TDT1Measure(TUCounts* tuCounts, int transmission, double minFreq, bool left):GroupBasedTDTMeasure (tuCounts, minFreq, left)");
transmission=(Transmission) trans;
totalMultipleTest=0;
if (tuCounts==NULL || tdtTable==NULL || tdtTable->partition==NULL) {zap(tdtTable);return;}
if (testMode==1) totalMultipleTest=tdtTable->partition->size(); // Bonferroni correction
setAll();
}
/*____________________________________________________________ */

TDTtable* TDT1Measure::set(TUCounts* aTUCounts)
{
TDTtable* whole=new TDTtable(aTUCounts->haplotypeTUCountsVector, NULL, 0, minFreq);
if (whole==NULL || whole->partition==NULL || whole->getTotalHeteroGenotypes()==0) {zap(whole);return NULL;}

TDTtable* result;
result=new TDTtable(2);
result->partition=whole->partition->clone();
result->partition->empty();
result->partition->insertElement(new HaplotypeSet(' ', '[',']'));
result->partition->insertElement(new HaplotypeSet(' ', '[',']'));
   double max=-1, a, b, diff, totalUsedHaplotypes=whole->getTotalTransmissionCount(ut);
 int pos=-1;
 			for(int i=0;i<whole->getYDim(); i++)
   {
   a=whole->getValue(0,i);
   b=whole->getValue(1,i);
   diff=std::pow((float)a-b,2)/(double)(a+b)+std::pow(a-b,2)/(double)(totalUsedHaplotypes-a-b);
   if (diff>max && (((transmission==t || transmission==ut) && a>b) || ((transmission==u || transmission==ut) && a<b)))
   {max=diff; pos=i;}
   }
   if (pos==-1) {zap(tdtTable); zap(whole); return NULL;}
 // cout <<"pos is:" << pos <<"\n";   
 // cout <<"table before:\n" << *tdtTable <<"\n";
 for(int i=0;i<whole->getYDim(); i++)
   if (i==pos)
   {
   result->partition->getElement(1)->insertHardElement(whole->partition->getElement(i)->getElement(0));
   result->setValue(0,1,whole->getValue(0,pos));
   result->setValue(1,1,whole->getValue(1,pos));
	 result->setValue(2,1,whole->getValue(2,pos));
   }  
 else result->partition->getElement(0)->insertHardElement(whole->partition->getElement(i)->getElement(0));
	 result->setValue(0,0,whole->getTotalTransmissionCount(t)-whole->getValue(0,pos));
   result->setValue(1,0,whole->getTotalTransmissionCount(u)-whole->getValue(1,pos));
   result->setValue(2,0,whole->getTotalHomoGenotypes()*2-whole->getValue(2,pos));  
  //   cout <<"table beforesemi:\n" << *tdtTable <<"\n";
zap(whole);
return result;
  //   cout <<"table after semi:\n" << *tdtTable <<"\n";
}



/*_________________________________________________________________*/

  TDT1Measure* TDT1Measure::getNewMeasure(TUCounts* tuCounts, TUCounts** tuCountsTraining, TUCounts** tuCountsTest)
{
return new TDT1Measure(tuCounts,transmission, minFreq, testMode, fold, tuCountsTraining, tuCountsTest);
}


/*___________________________________________________________________________*/


		TDT1Measure::~TDT1Measure(){
			};

/*___________________________________________________________________________*/

	string TDT1Measure::getName()
	{
	 string result=string("mTDT1");
 if (transmission==u) result=result+tos('U');
 if (transmission==t) result=result+tos('T');
 if (testMode==1) result=result+string("_Bonferroni");
 if (testMode==2) result=result+string("_cv")+tos(fold);
 if (minFreq!=0) result=result+string("_minFreq")+tos(minFreq);
	return result;
	};
/*___________________________________________________________________________*/


		TDT1Measure* TDT1Measure::clone(){
		 return new TDT1Measure(*this);
			};
	
/*_________________________________________________________________________________________________*/

		void TDT1Measure::onePrint(ostream& out, TUCounts* aTuCounts, TDTtable* aTDTtable)
{
try
{
out << "Positions: " << "[" << aTuCounts->getParentalGenotypes()->getPositions()[aTuCounts->getPositions()[0]] <<"-";
out << aTuCounts->getParentalGenotypes()->getPositions()[aTuCounts->getPositions()[aTuCounts->getTotalPos()-1]] <<"]\t";
out << "pVal:\t" << getPVal() <<"\t";
if (aTDTtable!=NULL && aTDTtable->partition!=NULL) 
{
if (1==0)
if (aTDTtable->partition->getElement(1)->size()>1) 
{
cout <<"there are "<<  aTDTtable->partition->getElement(1)->size() << " at second position\n ";
cout << *aTDTtable <<"\n";
throw BadFormat("void TDT1Measure::print(ostream& out)");
}
if (aTDTtable->partition->size()!=2)
throw BadFormat("TDT1Measure::onePrint"); 
out << " Haplotype:\t" << *aTDTtable->partition->getElement(1);
}
else out <<"nullTable";
}
catch (BasicException& be){be.addMessage("\ncalled from void TDT1Measure::print(ostream& out)"); throw;};
		};

/*___________________________________________________________________________________*/

/*

		double TDT1Measure::getStatistic()
		{
		if (transmission==ut) return Chi2TDTMeasure::getStatistic();
		else return Chi2TDTMeasure::getStatistic()/2;
   // if (tdtTable==NULL) return 0;
   // return std::pow(tdtTable->getValue(0,1)-tdtTable->getValue(1,1),2)/tdtTable->getHeteroHapCount (1,ut);
		};

/*_____________________________________________________________*/

/*
	doubleList* TDT1Measure::getHapFreqs()
  {
  doubleList* results=new doubleList();
  for (int i=0; i<getYDim(); i++) 
   results->insertElement((getValue(0,i)+getValue(1,i))/(double)getTotalCounts());
  return results;
  }



/*_____________________________________________________________*/

/*
	double TDT1Measure::getPVal()
  {
 try
{
double result;
//  if (transmission==ut) return Chi2TDTMeasure::getPVal();
if (tdtTable==NULL) return 1;
if (permutations) return SimpleTUMeasure::getPVal();
result=pdfTestChiSquare(getStatistic(),2);
if (isNAN(result)) 
{
cout << *tdtTable <<"\n";
cout <<"totalheteros:" << tdtTable->getTotalHeteroGenotypes()<<"\n";
cout << "statistic is: " << getStatistic();
throw NanValue(" Chi2TDTMeasure::getPVal()");
}
return result;
} 
catch (BasicException& be) {be.addMessage ("\ncalled from TDT1Measure::getPVal()"); throw;};

  }

/*_____________________________________________________________*/

	
};

#endif
