#ifndef __TDT1Measure_h__
#define __TDT1Measure_h__

namespace BIOS {
	
  /**
     @memo TDT1Measure
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class TDT1Measure: public GroupBasedTDTMeasure {
    
		public:
	

		/**
		*	Constructor
		*/		
	//	TDT1Measure();

		/**
		*	Destructor
		*/		
virtual		~TDT1Measure();

TDT1Measure* clone();


Transmission transmission;

  virtual TDT1Measure* getNewMeasure(TUCounts* tuCounts, TUCounts** training=NULL, TUCounts** test=NULL);

		/**
		*	Constructor 
		*	@param minFreq Min number of counts in an haplotype to be used
		*/		
		TDT1Measure(TUCounts* tuCounts, int transmission=1, double minFreq=10, int testMode=2, int fold=2, TUCounts** partialTuCountsTraning=NULL, TUCounts** partialTuCountsTest=NULL, bool left=true);
// transmission codes: {ut=0, t=1, u=2}
// testMode is 0 if usual testing (low specificity because of ad-hoc grouping
// testMode is 1 when Bonferroni correction is used (low power because it is an overcorrection)
// testMode is 2 when cross-validation fold 5 is used

		TDT1Measure(int transmission=1, double minFreq=10, int testMode=2, int fold=2, bool left=true);
		
				TDT1Measure(TDT1Measure& other);

	 virtual	TDTtable* set (TUCounts* aTUCounts=NULL);

 string getName();//{return string("mTDT1T");};
 
 void onePrint( ostream& , TUCounts* aTuCounts, TDTtable* aTDTtable);
		/**
		*	Calculate statistic from the tables 
		*/

// virtual	double getStatistic();

// virtual	double getPVal();

//virtual ostream& print(ostream&);





	};




};

#endif
