#ifndef __TDTMeasure_h__
#define __TDTMeasure_h__

namespace BIOS {
	
  /**
     @memo TDTMeasure
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class TDTMeasure: public Chi2TDTMeasure {
    
		public:
	

		/**
		*	Constructor
		*/		
	//	TDTMeasure(int minFreq=10, bool permutations=false);

		/**
		*	Destructor
		*/		
	virtual	~TDTMeasure();

TDTMeasure* clone();

		/**
		*	Constructor 
		*	@param minFreq Min number of counts in an haplotype to be used
		*/		
		TDTMeasure(TUCounts* tuCounts, double minFreq=10, bool permutations=false, bool left=true);

		TDTMeasure(double minFreq=10, bool permutations=false, bool left=true);

// stringList* getFreqsResults();

		/**
		*	Calculate statistic from the tables 
		*/

TDTMeasure* getNewMeasure(TUCounts* tuCounts, TUCounts** training=NULL, TUCounts** test=NULL);


//virtual stringList*  getHeadFile();

virtual string getName();//{return string("mTDT");};


//virtual ostream& print(ostream&);
	};


//ostream& operator<<(ostream& out, TDTMeasure& l);


};

#endif
