#ifndef __TDTPMeasure_cpp__
#define __TDTPMeasure_cpp__





namespace BIOS {

		TDTPMeasure::TDTPMeasure(TUCounts* tuCounts, double minFreq, bool independentCols, bool permutations, bool left):Chi2TDTMeasure(tuCounts, minFreq, permutations, left)
{
if (tdtTable!=NULL) weights=tdtTable->getHapFreqs();
else weights=NULL;
this->independentCols=independentCols;
		};

/*_________________________________________________________________*/

		TDTPMeasure::TDTPMeasure(double minFreq, bool independentCols, bool permutations, bool left):Chi2TDTMeasure(minFreq, permutations, left)
{
weights=NULL;
this->independentCols=independentCols;
		};

/*_________________________________________________________________*/

		TDTPMeasure::TDTPMeasure(TDTPMeasure& other):Chi2TDTMeasure(other)
{
if (tdtTable!=NULL) weights=tdtTable->getHapFreqs();
else weights=NULL;
this->independentCols=other.independentCols;
		};

/*_________________________________________________________________*/

		TDTPMeasure::~TDTPMeasure(){
  zap(weights);
 zap(tdtTable);
		};

/*_________________________________________________________________*/

		TDTPMeasure* TDTPMeasure::clone(){
  return new TDTPMeasure(*this);
		};

/*_________________________________________________________________*/

 string TDTPMeasure::getName()
{
 string result=string("mTDTP");
if (independentCols) result=result+string("_indep");
 if (minFreq!=0) result=result+string("_minFreq")+tos(minFreq);
 if (permutations) result=result+addPermutationsInName();
 return result;

};
/*_______________________________________________________________________________*/


		double TDTPMeasure::getStatistic()
		{
		if (weights!=NULL) return tdtTable->getWeightedStatistic(weights);
		else return 0;
		};

/*_________________________________________________________________*/

  TDTPMeasure* TDTPMeasure::getNewMeasure(TUCounts* tuCounts, TUCounts** training, TUCounts** test)
{
return new TDTPMeasure(tuCounts, minFreq, independentCols, this->permutations);
}
/*_____________________________________________________________________________________________________________*/



		doubleList* TDTPMeasure::getWeights()
		{
		return weights;
		};





/*_____________________________________________________________*/

	double TDTPMeasure::getPVal()
  {
  if (weights!=NULL)
  {
   if (tdtTable==NULL) throw NullValue("double TDTPMeasure::getPVal()");
  if (!independentCols) return pdfTestWeightedChiSquareTDT(getStatistic(), weights); 
  else return pdfTestWeightedChiSquareTDT2(getStatistic()*(tdtTable->getYDim()-1)/(double)tdtTable->getYDim(), weights); 
  }
  else return 1;
  }


/*_____________________________________________________________*/


		void TDTPMeasure::print(ostream& out)
{
if (weights!=NULL)
out <<"Hap freqs:" << *getWeights() <<"\n";
this->Chi2TDTMeasure::print(out);
}

};

#endif
