#ifndef __TDTPMeasure_h__
#define __TDTPMeasure_h__

namespace BIOS {
	
  /**
     @memo TDTPMeasure
     @doc
     Definition:
	 Class to compute TDTP statistic, which weighs each summand in the mTDT by haplotype frequencies and its null distribution is a weighted chi2

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class TDTPMeasure: public Chi2TDTMeasure {
    

private:

  doubleList* weights;

  bool independentCols;

		public:
	

		/**
		*	Constructor
		*/		
//		TDTPMeasure();

		/**
		*	Destructor
		*/		
virtual	~TDTPMeasure();


		/**
		*	Constructor 
		*	@param p 
		*/		
		TDTPMeasure(TUCounts* tuCounts, double minFreq=10, bool independentCols=false, bool permutations=false, bool left=true);

		TDTPMeasure(double minFreq=10, bool independentCols=false, bool permutations=false, bool left=true);
		
		

		
				TDTPMeasure(TDTPMeasure& other);

TDTPMeasure* clone();

  virtual TDTPMeasure* getNewMeasure(TUCounts* tuCounts, TUCounts** training=NULL, TUCounts** test=NULL);

virtual string getName();//{return string("mTDTP");};

		/**
		*	Calculate statistic from the tables 
		*/

	double getStatistic();

	//doubleList* getHapFreqs();


	double getPVal();


doubleList* getWeights();

virtual void print(ostream& out);



};


};

#endif
