#ifndef __TDTbranchCompositeMeasure_cpp__
#define __TDTbranchCompositeMeasure_cpp__


namespace BIOS {

	TDTbranchCompositeMeasure::TDTbranchCompositeMeasure(TUCounts* tuCounts, int k, double minFreq):
	  CompositeTUMeasure(tuCounts, 
		new TDTbranchSimpleMeasure(NULL, k), // Left Measure
		new TDTbranchSimpleMeasure(NULL, k)) // Right Measure
	{
		this->k = k;	
	};

	TDTbranchCompositeMeasure::TDTbranchCompositeMeasure(int k, double minFreq):
 	  CompositeTUMeasure( 
 		new TDTbranchSimpleMeasure(NULL, k), // Left Measure
 		new TDTbranchSimpleMeasure(NULL, k)) // Right Measure
	{
		this->k = k;
	};

	TDTbranchCompositeMeasure::TDTbranchCompositeMeasure(TDTbranchCompositeMeasure & other)
	:CompositeTUMeasure(other)
	{
		this->k = other.k;
	}

	string TDTbranchCompositeMeasure::getName(){
		return string("TDTbranch-"  + tos(k) );
	};

	string TDTbranchCompositeMeasure::getShortName(){
		return string("TDTB"  + tos(k) );
	};

/*_________________________________________________________________*/

  TDTbranchCompositeMeasure* TDTbranchCompositeMeasure::getNewMeasure(TUCounts* tuCounts, TUCounts** training, TUCounts** test)
{
	return new TDTbranchCompositeMeasure(tuCounts, k, minFreq);
}
/*_________________________________________________________________*/

/*
		TDTbranchCompositeMeasure::TDTbranchCompositeMeasure()
{
		};
		*/
/*_________________________________________________________________*/

		TDTbranchCompositeMeasure::~TDTbranchCompositeMeasure(){
  //tuCounts=NULL;
		};
/*_________________________________________________________________*/

		double TDTbranchCompositeMeasure::getStatistic(){
			throw NonImplemented("TDTbranchCompositeMeasure::getStatistic()");
		};
/*_________________________________________________________________*/

		stringList* TDTbranchCompositeMeasure::getHeadFile(){
throw NonImplemented("TDTbranchCompositeMeasure::getHeadFile()");
		};
/*_________________________________________________________________*/

		TDTbranchCompositeMeasure* TDTbranchCompositeMeasure::clone(){
 			return new TDTbranchCompositeMeasure(*this);
		};

/*
		TDTbranchCompositeMeasure* TDTbranchCompositeMeasure::inferMeasure(TUCounts *t){
 			//return (TDTbranchCompositeMeasure *) CompositeTUMeasure::inferMeasure(t);
	
			TDTbranchCompositeMeasure * compositeMeasure = new TDTbranchCompositeMeasure(tuCounts,k, minFreq);
			
			// Replace left and right measures 
			compositeMeasure->measureLeft = measureLeft->inferMeasure( measureLeft->tuCounts->clone() );
			compositeMeasure->measureRight = measureRight->inferMeasure( measureRight->tuCounts->clone() );
	
			return compositeMeasure;

		};
*/
/*_________________________________________________________________*/



/*_________________________________________________________________*/

		TUCounts* TDTbranchCompositeMeasure::getTUCounts(){
  return tuCounts;
		};

/*_____________________________________________________________*/


		void TDTbranchCompositeMeasure::print(ostream& out){
 throw NonImplemented(" TDTbranchCompositeMeasure::print(ostream& out)");
		};

/*_____________________________________________________________*/

  TDTbranchCompositeMeasure* TDTbranchCompositeMeasure::fromString(string s){throw NonImplemented("TDTbranchCompositeMeasure::fromString(string s)");};


};

#endif
