#ifndef __TUMeasure_cpp__
#define __TUMeasure_cpp__





namespace BIOS
{

  TUMeasure::TUMeasure (TUCounts* tuCounts, double minFreq, bool permutations) :GenericMeasure()
  {
    this->tuCounts=tuCounts;
    this->permutations=permutations;
    this->minFreq=minFreq;
//if (permutations) this->minFreq=0;
  };

  /*_________________________________________________________________*/

  TUMeasure::TUMeasure() :GenericMeasure()
  {
    this->tuCounts=NULL;
    this->permutations=false;
    this->minFreq=0;
  };
  /*_________________________________________________________________*/

  TUMeasure::TUMeasure (double minFreq, bool permutations) :GenericMeasure()
  {
    this->tuCounts=NULL;
    this->permutations=permutations;
    this->minFreq=minFreq;
  };
  /*_________________________________________________________________*/

  TUMeasure::TUMeasure (TUMeasure& other) :GenericMeasure()
  {
    this->tuCounts=other.tuCounts;
    this->permutations=other.permutations;
    this->minFreq=other.minFreq;
  };
  /*_________________________________________________________________*/
  /*

  		TUMeasure::TUMeasure(bool permutations):GenericMeasure()
  {
  this->permutations=permutations;
  hapExtractionConfiguration=NULL;
  		};
  /*_________________________________________________________________*/

  TUMeasure::~TUMeasure()
  {
    //tuCounts=NULL;
  };
  /*_________________________________________________________________*/
  /*
  		double TUMeasure::getStatistic(){
    return new TUMeasure(*this);
  		};

  /*_________________________________________________________________*/

  GenericMeasure* TUMeasure::getNewGenericMeasure (GenericCounts* tuCounts2, GenericCounts** training, GenericCounts** test)
  {
    try
    {
      return getNewMeasure ( (TUCounts*) tuCounts2, (TUCounts**)training, (TUCounts**) test);
    }
    catch (BasicException& be) {be.addMessage ("\ncalled from GenericMeasure* TUMeasure::getNewGenericMeasure(GenericCounts* tuCounts2) "); throw;};

  }

  /*_________________________________________________________________*/

  TUMeasure* TUMeasure::getNewMeasure (TUCounts* tuCounts2, TUCounts** training, TUCounts** test)
  {
    throw NonImplemented ("TUMeasure::getNewMeasure(GenericCounts* tuCounts2, int iniPos, int length)");
  }

  /*_________________________________________________________________*/

  TUMeasure* TUMeasure::inferMeasure (TUCounts* tuCounts2)
  {
    throw NonImplemented ("TUMeasure::inferMeasure(GenericCounts* tuCounts2");

  }

  /*_________________________________________________________________*/

  TUMeasure* TUMeasure::inferGenericMeasure (GenericCounts* tuCounts2)
  {
    return inferMeasure ( (TUCounts*) tuCounts2);
  }

  /*_________________________________________________________________*/
  /*
  	GenericCounts* TUMeasure::getCounts(char* filename, int totalPermutations, int* pos, int size)
  	{
  	cout <<"DDDD\n";
  cout <<"namefile is:" << filename;
  	TrioSample* ts=new TrioSample(filename);
  	cout <<"HERRR\n";
  	TUCounts* tuCounts2=ts->getTUCounts(pos, size, hapExtractionConfiguration, useOnlyHetero, totalPermutations);
  	cout <<"SSS\n";
  	zap(ts);
    return tuCounts2;
  	}


  /*_________________________________________________________________*/

  MeasureResults* TUMeasure::getResults()
  {
    //getPVal();
    try
    {
  //  if (Bonferroni) 
    return new StatisticalTestResults (getPVal(), getTotalMultipleTest() );
//else return new StatisticalTestResults (getPVal(), 0);
    }
    catch (BasicException& be) {be.addMessage ("\ncalled from MeasureResults* TUMeasure::getResults()"); throw;};
  }

  /*_________________________________________________________________*/

  TUCounts* TUMeasure::getTUCounts()
  {
    return tuCounts;
  };

/*_________________________________________________________________*/

  double TUMeasure::getTotalMultipleTest()
  {
    return 0;
  };

  /*_________________________________________________________________*/

  string TUMeasure::addPermutationsInName()
  {
    if (tuCounts!=NULL) return string ("_") +tos (tuCounts->getTotalPermutations() ) +string ("permutations");
    else return string ("_usingPermutations");
  };

  void TUMeasure::setTUCounts (TUCounts *t)
  {
    this->tuCounts = t;
  }


  /*_____________________________________________________________*/
  /*
  	double TUMeasure::getPVal()
    {
  cout <<"measure with perms is:" << this->getName() <<"\n";
    double result=1;
    doubleList* null=new doubleList();
    double* nullArray;
    TUMeasure* tu;

    if (tuCounts->getPermutations()==NULL) tuCounts->setPermutations();
    for (int i=0; i<tuCounts->getTotalPermutations(); i++)
    {
  //  if (i%10==0) cout <<"permutation " << i <<"\n";
   //cout <<"perm " << i <<" is: " << *tuCounts->getPermutations()[i] <<"\n";
     tu=this->getNewMeasure(tuCounts->getPermutations()[i]);
     null->insertElement(tu->getStatistic());
     zap(tu);
    }
    null->sort();
   // cout <<*null <<"\nwhile real value is:" << getStatistic() <<"\n";
    nullArray=null->getTable();
    result=getPValue(nullArray, tuCounts->getTotalPermutations(), getStatistic());
    zap(null);
    zaparr(nullArray);
    return result;
    }
  /*_____________________________________________________________*/

  TUMeasure* TUMeasure::fromString (string s) {throw NonImplemented ("TUMeasure::fromString(string s)");};


};

#endif
