#ifndef __TreeDTMeasure_cpp__
#define __TreeDTMeasure_cpp__





namespace BIOS {

	TreeDTMeasure::TreeDTMeasure(TUCounts* tuCounts, int maxK, double minFreq):TUMeasure(tuCounts)
	{

		assert( maxK >1 && maxK < 13);

		this->maxK = maxK;
		this->tuCounts = tuCounts;

	};


	double TreeDTMeasure::getPVal()
	{
		double minPvalue = 9999;

		for ( int i=2; i<=maxK; i++){
			TreeDTKMeasure * measure = tuCounts->getTreeDTKMeasure(i);
			double pValue = measure->getPVal();
			if ( pValue < minPvalue )
				minPvalue = pValue;		
			delete measure;			
		}

		return minPvalue;
	}


	string TreeDTMeasure::getName(){
		return string("TreeDT-"  + tos(maxK) );
	};


/*_________________________________________________________________*/

  TreeDTMeasure* TreeDTMeasure::getNewMeasure(TUCounts* tuCounts, TUCounts** training, TUCounts** test)
{
}
/*_________________________________________________________________*/

		TreeDTMeasure::TreeDTMeasure()
{
		};
/*_________________________________________________________________*/

		TreeDTMeasure::~TreeDTMeasure(){
  //tuCounts=NULL;
		};
/*_________________________________________________________________*/

		double TreeDTMeasure::getStatistic(){
			throw NonImplemented("TreeDTMeasure::getStatistic()");
		};
/*_________________________________________________________________*/

		stringList* TreeDTMeasure::getHeadFile(){
throw NonImplemented("TreeDTMeasure::getHeadFile()");
		};
/*_________________________________________________________________*/

		TreeDTMeasure* TreeDTMeasure::clone(){
 return new TreeDTMeasure(*this);
		};

/*_________________________________________________________________*/



/*_________________________________________________________________*/

		TUCounts* TreeDTMeasure::getTUCounts(){
  return tuCounts;
		};


/*_____________________________________________________________*/

  TreeDTMeasure* TreeDTMeasure::fromString(string s){throw NonImplemented("TreeDTMeasure::fromString(string s)");};

/*_________________________________________________________________*/

		void TreeDTMeasure::print(ostream& out){
   // out << *this;
   throw NonImplemented(" TreeDTMeasure::print(ostream& out)");
		};



};

#endif
