#ifndef __TreeDTMeasure_h__
#define __TreeDTMeasure_h__

namespace BIOS {
	
	/**
		@memo TreeDTMeasure
		@doc
		Definition:

		TreeDT algorithm inspired in Sevon et al. "TreeDT: Tree Pattern Mining for Gene Mapping" (2006)

		@author Jose J. Moreno
		@version 1.0
	*/	
	


	class TreeDTMeasure: public TUMeasure{

		int maxK;
		TUCounts* tuCounts;

		public:


		/**
		*	Constructor
		*/		
		TreeDTMeasure();

		/**
		*	Constructor
		*	@param maxK Maximum level k
		*/	

		TreeDTMeasure(TUCounts* tuCounts, int maxK, double minFreq=10);

		/**
		*	Destructor
		*/		
		virtual ~TreeDTMeasure();

		virtual TreeDTMeasure* clone();


		/**
		*	virtual methods to get pval of the measure.
		*	
		*/

		virtual double getStatistic();

		/**
		*	Calculates the p-value of the sample set as the minimum p_k. 
		*	A p_k value is calculated for each k.
		*	@see getPvalueForK()
		*	@return p-value		
		*/

		virtual double getPVal();


		virtual string getName();

		virtual stringList* getHeadFile();

		virtual TreeDTMeasure* getNewMeasure(TUCounts* tuCounts, TUCounts** training=NULL, TUCounts** test=NULL);

		TUCounts* getTUCounts();

		TreeDTMeasure* fromString(string s);

		//friend ostream& operator<<(ostream& out, TreeDTMeasure& l){};
		
		void print(ostream&);

	};



/*
{

}
*/

};

#endif
