#ifndef __TreeDTSimpleMeasure_cpp__
#define __TreeDTSimpleMeasure_cpp__

namespace BIOS {


	TreeDTSimpleMeasure::TreeDTSimpleMeasure(TreeDTSimpleMeasure & other)
	{
		permutations = true;
		this->k = other.k;
		this->useMaxK = useMaxK;
		this->tuCounts = other.tuCounts;
		if ( other.tdtTable != NULL )
			this->tdtTable = other.tdtTable->clone();
		else
			this->tdtTable = NULL;

	}


	TreeDTSimpleMeasure::TreeDTSimpleMeasure(TUCounts* tuCounts, int k, bool useMaxK, double minFreq):Chi2TDTMeasure(minFreq)
	{
		permutations = true;
		
		this->k = k;
		this->useMaxK = useMaxK;
		this->minFreq = minFreq;		

		if ( tuCounts != NULL)
			setTUCounts(tuCounts);
	};


	TreeDTSimpleMeasure::TreeDTSimpleMeasure(int k, bool useMaxK, double minFreq)
	{
		//TreeDTSimpleMeasure(NULL, K, minFreq);
		permutations = true;
		this->k = k;
		this->useMaxK = useMaxK;
		this->minFreq = minFreq;
	}


	void TreeDTSimpleMeasure::setTUCounts(TUCounts* tuCounts)
	{
		double max_z=-9999, last_z; // z value of the tdttable selected
		SetOfPartitions * partitions; // Set of all possible partitions 

		TDTtable * minTable=NULL;

		this->tuCounts = tuCounts;

		if ( this->tdtTable != NULL){
			delete tdtTable;
			tdtTable = NULL;
		}


		if (useMaxK){

			int maxK=2;
			for(int k_i=2; k_i<=k; k_i++){
 				//cout << endl<< "Checking k..." << k_i << endl;
				partitions = SetOfPartitions::splitVector( tuCounts->haplotypeTUCountsVector, k_i);	
				if ( partitions->size()){
					minTable = partitions->getTDTtableForMaxZ(last_z);
					if( last_z > max_z){
						if( this->tdtTable != NULL)
							delete tdtTable;
						this->tdtTable = minTable->clone();
						max_z = last_z;
						//cout << "z updated to: " << max_z << endl;
						maxK=k_i;
					}
					delete minTable;					
				}
				delete partitions;
			}
			//cout << "  maxK = " << maxK << endl;

		}
		else{

			partitions = SetOfPartitions::splitVector( tuCounts->haplotypeTUCountsVector, k);	
			if ( partitions->size() == 0)
				this->tdtTable = NULL;
			else
				this->tdtTable = partitions->getTDTtableForMaxZ(max_z);	

			delete partitions;	

		}

		
		
	};

// 	void TreeDTSimpleMeasure::createRandomizationDistribution()
// 	{
// 		rd = new RandomizationDistribution();
// 		double z;
// 		for (int j=0;j<tuCounts->getTotalPermutations();j++)
// 		{
// 			TUCounts * permutation = ( tuCounts->getPermutations() )[j];
// 			z = TreeDT::getMaxZstatistic(permutation->haplotypeTUCountsVector,  this->k);
// 			rd->values->insertElement( z );
// 		}
// 		rd->sort();
// 		//cout << "RD: " << *rd << endl;
// 
// 	};


	TreeDTSimpleMeasure::~TreeDTSimpleMeasure(){
// 		if ( rd!=NULL)
// 			delete rd;
	};


	double TreeDTSimpleMeasure::getStatistic(){

		//return TreeDT::getMaxZstatistic(tuCounts->haplotypeTUCountsVector,k);
		if (tdtTable!=NULL)
			return tdtTable->getStatisticZ();
		else return 0;

	};

// 	double TreeDTSimpleMeasure::getPVal()
// 	{
// 		if ( tuCounts->getPermutations() == NULL){
// 			// Create permutations
// 			tuCounts->setPermutations();
// 		}
// 		createRandomizationDistribution();
// 
// 		return TreeDT::getPvalueForK(tuCounts->haplotypeTUCountsVector,k,rd);
// 	}


	TreeDTSimpleMeasure* TreeDTSimpleMeasure::clone(){
		return new TreeDTSimpleMeasure(*this);
	};


	string TreeDTSimpleMeasure::getName(){
		

		if (useMaxK)
			return string("TreeDTSimpleMK"  + tos(k) );
		else
			return string("TreeDTsimple"  + tos(k) );

	};


	  TreeDTSimpleMeasure* TreeDTSimpleMeasure::getNewMeasure(TUCounts* tuCounts, GenericCounts** training, GenericCounts** test)
	{
		return new TreeDTSimpleMeasure(tuCounts, k, minFreq);
	}


	TreeDTSimpleMeasure::TreeDTSimpleMeasure()
	{

		throw NonImplemented("TreeDTSimpleMeasure::TreeDTSimpleMeasure()");
	
	};

	stringList* TreeDTSimpleMeasure::getHeadFile(){
		throw NonImplemented("TreeDTSimpleMeasure::getHeadFile()");
	};


	TUCounts* TreeDTSimpleMeasure::getTUCounts(){
		  return tuCounts;
	};

/*_________________________________________________________________*/

		void TreeDTSimpleMeasure::print(ostream& out){
 throw NonImplemented(" TreeDTSimpleMeasure::print(ostream& out)");
		};


/*_____________________________________________________________*/

  TreeDTSimpleMeasure* TreeDTSimpleMeasure::fromString(string s){throw NonImplemented("TreeDTSimpleMeasure::fromString(string s)");};


};

#endif
