#ifndef __WeightedTDTMeasure_h__
#define __WeightedTDTMeasure_h__

namespace BIOS {
	
  /**
     @memo WeightedTDTMeasure
     @doc
     Definition:
	Table to store T/U frecuencies for the TDT algorithm

     @author María del Mar Abad Grau
     @version 1.0
	
	*/	
class WeightedTDTMeasure: public Chi2TDTMeasure {
    
    private:

doubleList* weights;

bool equalWeights;
    
		public:
	

		/**
		*	Constructor
		*/		
	//	WeightedTDTMeasure();

		/**
		*	Destructor
		*/		
	virtual	~WeightedTDTMeasure();

WeightedTDTMeasure* clone();

		/**
		*	Constructor 
		*	@param minFreq Min number of counts in an haplotype to be used
		*/		
		WeightedTDTMeasure(TUCounts* tuCounts, double minFreq=10, bool  equalweights=false, bool permutation=false, bool left=true);

		WeightedTDTMeasure(double minFreq=10, bool  equalweights=false, bool permutations=false, bool left=true);


		WeightedTDTMeasure(WeightedTDTMeasure& other);

// stringList* getFreqsResults();

		/**
		*	Calculate statistic from the tables 
		*/

double getStatistic();

	doubleList* getWeights();

	double getPVal();

WeightedTDTMeasure* getNewMeasure(TUCounts* tuCounts, TUCounts** training=NULL, TUCounts** test=NULL);
WeightedTDTMeasure* inferMeasure(TUCounts* tuCounts);

//virtual stringList*  getHeadFile();

virtual string getName();//{return string("mTDT");};


void print(ostream&);
//friend ostream& operator<<(ostream& out, WeightedTDTMeasure& l);


	};





};

#endif
