/* File: TrioCounters.h */


#ifndef __TrioCounters_cpp__
#define __TrioCounters_cpp__





//using namespace stats;

namespace BIOS {


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/



/*____________________________________________________________ */

TrioCounters* TrioCounters::clone()
{
return new TrioCounters((TrioCounters&)*this);
} 
/*_________________________________________________________________*/

TrioCounters::TrioCounters(TrioCounters& source)
{
this->includeMissing=source.includeMissing;
this->totalPos=source.totalPos;
this->totalGenotypes=source.totalGenotypes;
this->trioSample=source.trioSample;
genotypeCountsFather=NULL;
genotypeCountsMother=NULL;
//fatherPedigrees=NULL;
//motherPedigrees=NULL;
SNPAbsFreqsFather=NULL;
SNPAbsFreqsMother=NULL;
genotypeArray=NULL;
pos=NULL;
//if (source.genotypeFreqs!=NULL) genotypeFreqs=new HeteroListPair<long long int, double>(*source.genotypeFreqs);
//if (source.genotypeAbsFreqsTab!=NULL) genotypeAbsFreqsTab=new MultidimensionalTable<double>(*source.genotypeAbsFreqsTab);
if (source.totalPos>0)
{
pos=Initialize(totalPos,0);
for (int i=0; i<totalPos; i++)
pos[i]=source.pos[i];
}
if (source.genotypeCountsFather!=NULL) genotypeCountsFather=new longLongList(*source.genotypeCountsFather);
if (source.genotypeCountsMother!=NULL) genotypeCountsMother=new longLongList(*source.genotypeCountsMother);
//if (source.fatherPedigrees!=NULL) fatherPedigrees=new intList(*source.fatherPedigrees);
//if (source.motherPedigrees!=NULL) motherPedigrees=new intList(*source.motherPedigrees);

if (source.genotypeArray!=NULL) genotypeArray=new GenotypeArray(*source.genotypeArray);
double** sourceSNPAbsFreqs=source.SNPAbsFreqsFather, **SNPAbsFreqs;
for (int parent=0; parent<2; parent++)
{
if (parent==1) {sourceSNPAbsFreqs=source.SNPAbsFreqsMother;}
if (sourceSNPAbsFreqs!=NULL)
{
if (parent==0) {SNPAbsFreqsFather=new double*[this->totalPos]; SNPAbsFreqs=SNPAbsFreqsFather;} 
else {SNPAbsFreqsMother=new double*[this->totalPos]; SNPAbsFreqs=SNPAbsFreqsMother;} 
for (int i=0; i<this->totalPos; i++)
{
 SNPAbsFreqs[i]=new double[genotypeArray->totalAlleles[i]];
 for (int j=0; j<genotypeArray->totalAlleles[i]; j++) SNPAbsFreqs[i][j]=sourceSNPAbsFreqs[i][j];
if (parent==0) SNPAbsFreqsFather[i]=SNPAbsFreqs[i]; 
else SNPAbsFreqsMother[i]=SNPAbsFreqs[i]; 
}
}
else if (parent==0) SNPAbsFreqsFather=NULL; else SNPAbsFreqsMother=NULL;
}


}
/*_________________________________________________________________*/

MultidimensionalTable<longLongList*>* TrioCounters::getPointersToPartnerGenotypes(IndCategory icPartner)
{
if (icPartner!=father && icPartner!=mother) throw BadFormat(string("TrioCounters::getPointersToPartnerGenotypes"));
longLongList* list, *list2;
intList* dimList=new intList();
for (int i=0; i<this->totalPos; i++)
 dimList->insertElement(getTotalGenotypes(genotypeArray->totalAlleles[i]));
MultidimensionalTable<longLongList*>*result=new MultidimensionalTable<longLongList*>(dimList);
zap(dimList);
for (int i=0; i<result->getSize(); i++) result->setValue(i, NULL);
longLongList* partner=genotypeCountsFather;
longLongList* current=genotypeCountsMother;
if (icPartner==mother)
{
partner=genotypeCountsMother;
current=genotypeCountsFather;
}
//else cout <<"for mother\n";
long long int currentValue, partnerValue;
longLongList * pointerList;
for (int i=0; i<current->size(); i++)
if (current->getElement(i)>=0)
{
currentValue=current->getElement(i);
partnerValue=partner->getElement(i);
//cout <<"current:" << currentValue <<" and partner" << partnerValue <<"\n";
pointerList=result->getValue(currentValue);
if (pointerList==NULL) {pointerList=new longLongList(); result->setValue(currentValue, pointerList);};
pointerList->insertElement(partnerValue);
//cout <<" result at pos " << currentValue <<" :  " << *result->getValue(currentValue);
}
//exit(0);
return result;
}

/*_________________________________________________________________*/

TrioCounters::TrioCounters(SNPPos Pos[], SNPPos TotalPos,  TrioSample * samp, int affectation, bool includeMissing) 
{
try
{
trioSample=samp;
genotypeCountsFather=NULL;
genotypeCountsMother=NULL;
//fatherPedigrees=NULL;
//motherPedigrees=NULL;
genotypeArray=NULL;
SNPAbsFreqsFather=NULL;
SNPAbsFreqsMother=NULL;
set (Pos, TotalPos, samp, affectation, includeMissing);
}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from TrioCounters::TrioCounters(SNPPos Pos[]..."); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from TrioCounters::TrioCounters(SNPPos Pos[]..."); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from TrioCounters::TrioCounters(SNPPos Pos[]..."); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from TrioCounters::TrioCounters(SNPPos Pos[]..."); throw;};
}

/*_________________________________________________________________*/

TrioCounters::TrioCounters()
{
genotypeCountsFather=NULL;
genotypeCountsMother=NULL;
//fatherPedigrees=NULL;
//motherPedigrees=NULL;
genotypeArray=NULL;
SNPAbsFreqsFather=NULL;
SNPAbsFreqsMother=NULL;
includeMissing=false;
totalPos=0;
pos=NULL;
trioSample=NULL;
}
/*_______________________________________________________________*/

 void TrioCounters::empty()
{
zap(genotypeCountsFather);
zap(genotypeCountsMother);
//zap(fatherPedigrees);
//zap(motherPedigrees);
zap(genotypeArray);

for (int i=0; i<totalPos; i++)
{
if (SNPAbsFreqsFather!=NULL) zaparr(SNPAbsFreqsFather[i]);
if (SNPAbsFreqsMother!=NULL) zaparr(SNPAbsFreqsMother[i]);
}

zaparr(SNPAbsFreqsFather);
zaparr(SNPAbsFreqsMother);
zaparr(pos);
}

/*_______________________________________________________________*/

MultidimensionalTable<double>*  TrioCounters::getGenotypeAbsFreqs(IndCategory member) 
{
longLongList* list, *list2;
intList* dimList=new intList();
long long int size=1;
for (int i=0; i<this->totalPos; i++)
{
size=size*getTotalGenotypes(genotypeArray->totalAlleles[i]);
 dimList->insertElement(getTotalGenotypes(genotypeArray->totalAlleles[i]));
}


#ifdef _CMP_MAC_
if (size>INT_MAX)
#else
if (size>MAXINT)
#endif	
{
cout <<"Try a shorter windows\n";
throw NoMemory("getGenotypeAbsFreqs(IndCategory member)");
}

MultidimensionalTable<double> *result=new MultidimensionalTable<double>(dimList);

zap(dimList);
int cont=0;
if (member==offspring || member==everybody) throw BadFormat(string("TrioCounters::getGenotypeAbsFreqs"));
for (int i=0; i<2; i++)
if (member==father && i==0 || member==mother && i==1 || member==parent)
{
if (i==0) {list=genotypeCountsFather; list2=genotypeCountsMother;} else {list=genotypeCountsMother; list2=genotypeCountsFather;};
for (longLongList::iterator it=list->begin(); it<list->end(); it++)
if (list->getElement(it)!=-1)//missing when includeMissing=false are disregarded; homozygous when tdt=true are disregarded
{
result->addValue(list->getElement(it), 1);
cont++;
}
}
return result;
}


/*_________________________________________________________________*/

 void TrioCounters::set(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation, bool includeMissing)  
{
try
{
this->totalPos=totalPos;
this->includeMissing=includeMissing;
set(samp, affectation, Pos);
}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from TrioCounters::set(SNPPos Pos[]..."); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from TrioCounters::set(SNPPos Pos[]..."); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from TrioCounters::set(SNPPos Pos[]..."); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from TrioCounters::set(SNPPos Pos[]..."); throw;};
}
/*_______________________________________________________________*/

 void TrioCounters::setGenotypeTableDimensions(TrioSample * samp)
{
try
{
intList* dimList=new intList();
for (int i=0; i<totalPos; i++)
{
//cout <<"pos at " << i << ": " << pos[i] << " ";
//cout <<"total alleles:" << samp->genotypeSample->totalAlleles[pos[i]] <<"\n";
 dimList->insertElement(getTotalGenotypes(samp->genotypeSample->totalAlleles[pos[i]]));
}
//cout <<"dimList:" << *dimList <<"\n";
//if (samp!=NULL) if (samp->genotypeSample!=NULL) cout <<"NONULL\n";
genotypeArray=new GenotypeArray(dimList, pos[0], samp->genotypeSample->totalAlleles, samp->genotypeSample->allAlleles);
zap(dimList);
}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from TrioCounters::setGenotypeTableDimensions(TrioSample* sample..."); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from TrioCounters::setGenotypeTableDimensions(TrioSample* sample..."); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from TrioCounters::setGenotypeTableDimensions(TrioSample* sample..."); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from TrioCounters::setGenotypeTableDimensions(TrioSample* sample..."); throw;};
}
/*_______________________________________________________________*/
/*
 void TrioCounters::setGenotypeTable()
{
longLongList * genotypeCounts;
for (int i=0; i<2; i++)
{
if (i==0) genotypeCounts=genotypeCountsFather; else genotypeCounts=genotypeCountsMother;
for (longLongList::iterator it=genotypeCounts->begin(); it!=genotypeCounts->end(); it++)
 genotypeArray->addValue(genotypeCounts->getElement(it), 1);
}
}
/*_______________________________________________________________*/

 longLongList*TrioCounters::permuteInParent(bool father)
{
// It returns a new list of genotype codes for each individual randomly changing between T/U
long int value, value2;
int transmitted;
longLongList* result=new longLongList(), *temp;
if (father) 
temp=genotypeCountsFather;
else temp=genotypeCountsMother;
for (longLongList::iterator it=temp->begin(); it<temp->end(); it++)
{
value=temp->getElement(it);
transmitted=ranbinom(1, 0.5);
if (transmitted)
{
result->insertElement(value);
}
else
{
value2=genotypeArray->changePhase(value);
result->insertElement(value2);
//cout << "\npermutation: orig:"  << value << "new:" << value2;
}
}
return result;
}

/*___________________________________________________________________________________________________*/

 void TrioCounters::setSNPFreqs()  
{
try
{
SNPAbsFreqsFather=new double*[totalPos];
SNPAbsFreqsMother=new double*[totalPos];
int al1, al2, al3, al4;
double totalSNP=0, freq=0;
for (int i=0; i<totalPos; i++)
{
 SNPAbsFreqsFather[i]=Initialize(genotypeArray->totalAlleles[i], 0.0);
 SNPAbsFreqsMother[i]=Initialize(genotypeArray->totalAlleles[i], 0.0);
}

int i=0, *position=NULL, *position2=NULL;
if (genotypeCountsFather==NULL)
throw NullValue("TrioCounters::setSNPFreqs()");

if (genotypeCountsMother==NULL)
throw NullValue("TrioCounters::setSNPFreqs()");

if (genotypeCountsFather->size() != genotypeCountsMother->size())
throw OutOfBounds(genotypeCountsFather->size(), genotypeCountsMother->size(), "TrioCounters::setSNPFreqs()");
for (int i=0; i<genotypeCountsFather->size(); i++)
{
if (genotypeCountsFather->getElement(i)>=0)
{
position=genotypeArray->getPositions(genotypeCountsFather->getElement(i));
for (int j=0; j<totalPos; j++)
{
 al1=getAllelePos(position[j], j, true, genotypeArray);
 al2=getAllelePos(position[j], j, false, genotypeArray);
 SNPAbsFreqsFather[j][al1]=SNPAbsFreqsFather[j][al1]+1;
 SNPAbsFreqsFather[j][al2]=SNPAbsFreqsFather[j][al2]+1;
}
zaparr(position);
}
if (genotypeCountsMother->getElement(i)>=0)
{
position2=genotypeArray->getPositions(genotypeCountsMother->getElement(i));
for (int j=0; j<totalPos; j++)
{
 al3=getAllelePos(position2[j], j, true, genotypeArray);
 al4=getAllelePos(position2[j], j, false, genotypeArray);
 SNPAbsFreqsMother[j][al3]=SNPAbsFreqsMother[j][al3]+1;
 SNPAbsFreqsMother[j][al4]=SNPAbsFreqsMother[j][al4]+1;
}
zaparr(position2);
}
}
}
catch (ORLLI & e) {e.addMessage("\n called from TrioCounters::setSNPFreqs()"); throw; }
catch (NonImplemented & ni){ni.addMessage("\ncalled from TrioCounters::setSNPFreqs()"); throw;}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from TrioCounters::setSNPFreqs"); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from TrioCounters::setSNPFreqs"); throw;}
}
/*_______________________________________________________________*/
/*
 longLongList*TrioCounters::updatePermutationsInChildren(longLongList* genotypeCountsFather, longLongList* genotypeCountsMother)
{
// It updates the permutations in the children
longLongList* result=new longLongList();
long int valueMother, valueFather, valueChild;
int alMother, alFather, *positionsFather, *positionsMother, *positionsChild;
for (int cont=0; cont<genotypeCountsFather->size(); cont++)
{
valueMother=genotypeCountsMother->getElement(cont);
valueFather=genotypeCountsFather->getElement(cont);
positionsFather=genotypeArray->getPositions(valueFather);
positionsMother=genotypeArray->getPositions(valueMother);
positionsChild=genotypeArray->getPositions(valueChild);
for (int i=0; i<totalPos; i++)
if (genotypeArray->isAKnownPosition (positionsFather[i], i)) 
if (genotypeArray->isAPositionWithDifferentValues(positionsFather[i], i) || genotypeArray->isAPositionWithDifferentValues(positionsMother[i], i)) 
{
alFather=genotypeArray->getKnownValue (positionsFather[i], i, true);
alMother=genotypeArray->getKnownValue (positionsMother[i], i, true);
positionsChild[i]=genotypeArray->getAmbiguousPos (alFather, alMother, i);
}
valueChild=genotypeArray->getPos(positionsChild);
zaparr(positionsFather);
zaparr(positionsMother);
zaparr(positionsChild);
result->insertElement(valueChild);
}
return result;
}
/*_______________________________________________________________*/

TrioCounters*TrioCounters::getPermutation()
{
//if (Bayes!=MLE) throw BadFormat("TrioCounters<T>::getPermutation()");
longLongList
* tempGenotypeCountsFather=permuteInParent(true),
* tempGenotypeCountsMother=permuteInParent(false);


TrioCounters* result=clone();
zap(result->genotypeCountsFather);
zap(result->genotypeCountsMother);
result->genotypeCountsFather=tempGenotypeCountsFather;
result->genotypeCountsMother=tempGenotypeCountsMother;
//zap(result->genotypeFreqs);
//zap(result->genotypeAbsFreqsTab);
//result->setGenotypeFreqs();
//result->setGenotypeAbsFreqs();
return result;
}
/*_______________________________________________________________*/

 void TrioCounters::setTotalGenotypes()
{
try
{
longLongList* l;
totalGenotypes=0;
for (int parent=0; parent<2; parent++)
{
if (parent==0) l=genotypeCountsFather; else genotypeCountsMother;
for (longLongList::iterator it=l->begin(); it<l->end(); it++)
if (l->getElement(it)>=0) totalGenotypes++;
}
}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from TrioCounters::setTotalGenotypes"); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from TrioCounters::setTotalGenotypes()"); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from TrioCounters::setTotalGenotypes"); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from 3 TrioCounters::ssetTotalGenotypes"); throw;};
}
/*_________________________________________________________________*/

void TrioCounters::set(TrioSample* sample, int affectation, int* pos)  
{
try
{

if (totalPos>0)
{
this->pos=Initialize(totalPos,0);
for (int i=0; i<totalPos; i++)
this->pos[i]=pos[i];
}
setGenotypeTableDimensions(sample);
setCounters(sample, affectation, pos);
setTotalGenotypes();
setSNPFreqs();
}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from TrioCounters::set(TrioSample* sample..."); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from TrioCounters::set(TrioSample* sample..."); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from TrioCounters::set(TrioSample* sample..."); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from TrioCounters::set(TrioSample* sample..."); throw;};
}



/*____________________________________________________________ */

void TrioCounters::setCounters (TrioSample* sample, int affectation, int*pos)  
{
try
{
genotypeCountsFather=sample->getGenotypeCounts(pos, totalPos, father, affectation, everyGender, genotypeArray, false, includeMissing);
genotypeCountsMother=sample->getGenotypeCounts(pos, totalPos, mother, affectation, everyGender, genotypeArray, false, includeMissing);
//fatherPedigrees=sample->getPedigreeID(father);
//motherPedigrees=sample->getPedigreeID(mother);
}
catch (OutOfBounds& ob){ob.addMessage("\ncalled from TrioCounters::setCounters"); throw;}
catch (NonImplemented & ni){ni.addMessage("\ncalled from TrioCounters::setCounters"); throw;}
catch (ORI & ori){ori.addMessage("\ncalled from TrioCounters::setCounters"); throw;}
catch (ORLLI & e) {e.addMessage("\ncalled from TrioCounters::setCounters"); throw;};
//cout <<"mother gens:\n" << *genotypeCountsMother;
}

/*_________________________________________________________________*/

TUCounts * TrioCounters::getPermutationTUCounts (HapExtractionConfiguration* hapExtractionConfiguration)
{
throw NonImplemented("TrioCounters::getPermutationTUCounts (HapExtractionConfiguration* hapExtractionConfiguration)");
/*
TrioCounters* trioCounters2;
TrioCountersHapUAndT* tm=NULL;
HapExtractionConfiguration* hapExtractionConfiguration2=new HapExtractionConfiguration(*hapExtractionConfiguration);

while (tm==NULL)
{
trioCounters2=getPermutation();
tm=new TrioCountersHapUAndT(trioCounters2, hapExtractionConfiguration->phaseAlg, hapExtractionConfiguration->emDistributions, hapExtractionConfiguration->emRestriction);
if (tm->haplotypeCounts==NULL) {zap(tm);zap(trioCounters2);}
}
HeteroPair<HaplotypeTUCountsVector*,ParentalHaplotypesUsingPointersList*>* h=tm->getTUCounts();
HaplotypeTUCountsVector* haplotypeTUCountsVector2=h->first();
ParentalHaplotypesUsingPointersList* parentalHaplotypesList2=h->second();
h->First=NULL;
h->Second=NULL;
TUCounts* result=new TUCounts(trioCounters2, hapExtractionConfiguration2, haplotypeTUCountsVector2, parentalHaplotypesList2);
zap(tm);
zap(h);
return result;
*/
}


};  // End of Namespace

#endif

/* End of file: TrioCounters.h */




