/* File: TrioCounters.h */

#ifndef __TrioCounters_h__
#define __TrioCounters_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S TrioCounters DEFINITION */
/************************/


/**
        @memo TrioCounters for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
class TrioCounters {


public:

    /** @name Declaration of class TrioCounters
        @memo Private part.
    */

	 
private:





bool includeMissing;



       
/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */

 

		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:

double** SNPAbsFreqsFather, **SNPAbsFreqsMother;


SNPPos *pos;

SNPPos totalPos;

			double totalGenotypes;

GenotypeArray* genotypeArray;

TrioSample * trioSample;
 
longLongList* genotypeCountsFather,* genotypeCountsMother; // there are as many genotypes in each list as the number of parents
//intList* fatherPedigrees,* motherPedigrees; // there are as many pedigrees in each list as the number of parents

      /** @name Operations on TrioCounters 
        @memo Operations on a TrioCounters 
    */
	TrioCounters(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation=allAffectation, bool includeMissing=true) ;

	
 TrioCounters(TrioCounters& source);
 TrioCounters();

	void set(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation, bool includeMissing=true);

	TrioCounters(TrioSample * samp);

//TrioCounters<T>* convertToKnownGenotypes(MultidimensionalTable<double>* haplotypeFreqsTab, MultidimensionalTable<double>* haplotypeFreqsTabU);

 void empty();


	~TrioCounters()
	{
empty();
	};

//void setGenotypeFreqs ();

//void setGenotypeTable();

void setGenotypeTableDimensions(TrioSample * samp);

MultidimensionalTable<longLongList*>* getPointersToPartnerGenotypes(IndCategory ic);

longLongList* permuteInParent(bool father);


//double getTotalKnown();

void setSNPFreqs();

//IndPos getHapFreq(int* pos);

//IndPos getHapFreq(int pos);

   //     int GetAllelePair();

//	int getTotalDifferentHaplotypes();

MultidimensionalTable<double>* getGenotypeAbsFreqs(IndCategory ic) ;

	
//longLongList* updatePermutationsInChildren(longLongList* genotypeCountsFather, longLongList* genotypeCountsMother);

//	void GetSampleFrequencies(IndPos & bnAB, IndPos & bnAb,IndPos & bnaB,IndPos & bnab);

	 TrioCounters* clone();


	 void set(TrioSample* sample, int affectation, int* pos) ;

	 void setCounters(TrioSample* sample, int affectation, int* pos) ;



void setTotalGenotypes();


// BidimensionalTable<double>* getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans);



//bool isSNP(SNPPos i);

//BidimensionalTable<double>* getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans);

virtual TrioCounters * getPermutation ();

// ostream& print (ostream& out) {out << *this; return out;};

//CPT* getCPT(bool disease0-sex1);


TUCounts * getPermutationTUCounts (HapExtractionConfiguration* hapExtractionConfiguration);


};  // End of class TrioCounters

ostream& operator<<(ostream& out, TrioCounters& pm)
       {

out <<"pos: ";
for (int i=0; i<pm.totalPos; i++)
 out << pm.pos[i] <<" ";

out <<"\n";

/*
cout <<"genotype codes:\n" << *pm.genotypeArray;
intList* posList;
//if (1==0)
for (int i=0; i<pm.genotypeArray->getSize(); i++)
{
posList=pm.genotypeArray->getPosList(i);
posList->setDelimiters('\0', '\0'); 
cout << "Genotype id  " << i <<". Coded: " << *posList <<". Decoded: ";
for (int j=0; j<pm.genotypeArray->dimensionList->size(); j++)
{
// cout << getAllelePos (posList->getElement(j), j, true, pm.genotypeArray);

 cout << pm.genotypeArray->getAllele(j, getAllelePos (posList->getElement(j), j, true, pm.genotypeArray));

 if (pm.genotypeArray->isAKnownPosition(posList->getElement(j), j))
 cout <<"-"; else cout <<"/";
// cout << getAllelePos (posList->getElement(j), j, false, pm.genotypeArray) <<" ";

 cout << pm.genotypeArray->getAllele(j, getAllelePos (posList->getElement(j), j, false, pm.genotypeArray) ) << " ";
}
cout <<"\n";
zap(posList);
}

*/
if (pm.genotypeCountsFather!=NULL)
{
pm.genotypeCountsFather->setOutputSeparator('\n');
out <<"\npaternal genotypes: \n" << *pm.genotypeCountsFather;
}
//if (pm.fatherPedigrees!=NULL)
//cout <<"\nfather pedigree: " << *pm.fatherPedigrees;

if (pm.genotypeCountsMother!=NULL)
{
pm.genotypeCountsMother->setOutputSeparator('\n');
out <<"\nmaternal genotypes: \n" << *pm.genotypeCountsMother;
}

//if (pm.motherPedigrees!=NULL)
//cout <<"\nmother pedigree: " << *pm.motherPedigrees;

  // out << *pm.haplotypeCounts;
// out << pm.GetnA() <<", " << pm.GetnB()  <<", " << pm.GetTotalKnown() <<", " << pm.GetTotalUnKnown()  <<", " << pm.GetnAB() <<"\n";

return out;
};



};  // End of Namespace

#endif

/* End of file: TrioCounters.h */




