/* File: PhylogeneticDistance.h */

#ifndef __TrioCountersHapUAndT_h__
#define __TrioCountersHapUAndT_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo MultimarkerMeasure for SNPs

	@doc
        Definition:

       Class used to obtain haplotypes from genotypes. 

       With this purpose, the data structures required is:
 
       Container vector, ParentalHaplotypes> *parentalHaps   

        @author Maria M. Abad
	@version 1.0
*/



 
class	TrioCountersHapUAndT {

//MultimarkerMeasureHap<TrioSample> *multimarkerMeasureTransmitted, *multimarkerMeasureUntransmitted;

private:


public:
PhaseAlg phaseAlg;
EMDistributions emDistributions;
EMRestriction emRestriction;


TrioCounters* trioCounters;
FreqAndKeyVector* hapByFreqs, *hapByFreqsT, *hapByFreqsU;
	   double** SNPAbsFreqsFatherT, **SNPAbsFreqsFatherU, ** SNPAbsFreqsMotherT, **SNPAbsFreqsMotherU;
//   double** SNPFreqs;
ParentalHaplotypesList* haplotypeCounts; // the number of parental haplotypes is the same of the number of trios for phaseAlg= onlyKnown or phaseAlg=maxFreq. For phaseAlg=weighted, there can be more parental haplotypes than the number of trios 
double totalDifferentHaplotypes, totalUsedDifferentHaplotypes;
MultidimensionalEmptyTable<int>* haplotypeTable;



/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/


      public:



//	TrioCountersHapUAndT(SNPPos Pos[], SNPPos totalPos, TrioSample * samp, int affectation=allAffectation, PhaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction, bool includeMissing=false, bool onlyHetero=true, int minFreq=10);
	
 TrioCountersHapUAndT(TrioCountersHapUAndT& source);
 
TrioCountersHapUAndT(TrioCounters* source, PhaseAlg phaseAlg=weighted, EMDistributions emDistributions=UTDistributions, EMRestriction emRestriction=triosBasedRestriction);

 TrioCountersHapUAndT();

 void set(TrioCountersHapUAndT& source);
long long int getHapAtPosition (int hapPosition=1, Transmission transmissionHapPosition=t);

void setHapByFreqs();

MultidimensionalEmptyTable<int>* getHaplotypeArray();

void setSNPFreqs();

void setHaplotypeCounts();
Pair<Pair<MultidimensionalTable<double>*>*>*  getKnownHaplotypeFreqs();
long long int getHap(const long long int value, bool left);
Pair<Pair<MultidimensionalTable<double>*>*>* getHaplotypeFreqsTab() throw (NoMemory, BadFormat);
double getNormalizationValue(int totalConfigurations, long long int ambiguousPosFather, long long int ambiguousPosMother, Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairFather,Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairMother);
ParentalHaplotypes* getParentalHaplotypes(long long int ambiguousConfFather, long long int ambiguousConfMother, int binaryKnownConfiguration);
double getCurrentFrequency(Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairFather,Pair<MultidimensionalTable<double>*>* haplotypeFreqsTabPairMother, ParentalHaplotypes *parentalHaplotype);
Pair<Pair<MultidimensionalTable<double>*>*>* getHaplotypeFreqsTab(int type, MultidimensionalTable<double>* genotypeAbsFreqsTab, MultidimensionalTable<longLongList*>* pointersToPartnerGenotypes) throw (NoMemory, BadFormat);
MultidimensionalTable<double>* getInitialEstimation(int type);
//double getIndependentLociFrequency (long long int key);
 ~TrioCountersHapUAndT()
{
empty();
	};

//void normalizeFreqs(double total);

void empty ();
//string getHaplotype(long long int key);
//doubleList* getWeightsInWTDT(IndCategory ic, int type=0);
//double getTotalHeteroGenotypes (IndCategory ic);
void setTotalHaplotypes();
//BidimensionalTable<double>* getMultiallelicFreqs(SNPPos a, SNPPos b, Transmission trans, IndCategory ic=parent);
//int getHapPositionByFreq (long long int hapCode, Transmission transmissionHapPosition);
//int getTotalDifferentPhasing (int trioCount);
//double getTotalUsedDifferentHaplotypesInG1();
//double getTotalUsedHaplotypesInG(bool g1);
TrioCountersHapUAndT* clone();
//double getLengthMeasure (long long int pos1T, long long int pos2T, long long int pos1U, long long int pos2U);
 void setHaplotypeTable();
 //double getStandardizedSimilarityMeasure (IndCategory ic=parent);
 //double getSignedRankTest(bool wilcoxon=true, IndCategory ic=parent);
 //double getSimilarityMeasure (IndCategory ic=parent);
double getTotalHaplotypes (long long int hap, Transmission trans, IndCategory ic=parent, Homozygosity h=allHomozygosity) throw (BadFormat);
//double getTotalMeiosis (long long int hap, long long int hap2, IndCategory ic) throw (BadFormat);
double getTotalHomoGenotypes (long long int hap, IndCategory ic) throw (BadFormat);
double getTotalHeteroGenotypes (long long int hap, IndCategory ic) throw (BadFormat);
//double getTest (int testType, IndCategory ic=parent) throw (BadFormat);
TrioCountersHapUAndT* getPermutation(); //{throw NonImplemented("getPermutation");};

HeteroPair<HaplotypeTUCountsVector*,ParentalHaplotypesUsingPointersList*>* getTUCounts(bool onlyHetero=true);


};  // End of class MultimarkerMeasure




ostream& operator<<(ostream& out, TrioCountersHapUAndT& pm)
       {
//if (pm.trioCounters!=NULL)
//   out << *pm.trioCounters <<"\n";

if (pm.haplotypeCounts!=NULL)
   out << *pm.haplotypeCounts << "\n";

return out;
};

};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */


//double getSquareSB (int type, int hapPosition=1, Transmission transmissionHapPosition=t);
//double getSquareSB (int type, Transmission trans, int hapPosition=1, Transmission transmissionHapPosition=t);
//double getEntropySB (bool df);
//double getEntropySB (bool df, Transmission trans);
//double getLinearSB (bool df, Transmission trans);
//double getSignedRank (Container<vector<Pair<double>*>, Pair<double> *>* DList, double totalCounts, int testType);
//double getEntropySE(bool df);
//double getEntropyBasedLD (bool df, Transmission trans);
//double getMultimarkerDPrime (int type, bool df);

//double getMultimarkerDPrime (int measure, bool df, Transmission trans);
//double getDPrime(BidimensionalTable<double> * multiallelicFreqs, int measure, bool df);
//double getTDT (IndCategory ic=parent);
//double getTTDT (IndCategory ic=parent);
//double getUTDT (IndCategory ic=parent);
//double getSimpleTDT(IndCategory ic=parent, int hapPosition=1, Transmission transmissionHapPosition=ut);
//double getScoreTDT (IndCategory ic=parent);
//double getScoreEntropyTDT (IndCategory ic=parent);
//double getSNPAbsVarTDT (IndCategory ic=parent);
//double getSNPSquareVarTDT (IndCategory ic=parent);
//double getSNPSquareCorrectedVarTDT (IndCategory ic=parent);
//double getNTDT (IndCategory ic=parent);
//double getNTDTExternalWeights (IndCategory ic, doubleList* weights) throw (NullValue);
//double getWTDT (IndCategory ic=parent) throw (NonDefined);
//double getWWTDT (IndCategory ic=parent) throw (NonDefined);
//double getEntropyTDT (IndCategory ic=parent);
//double getGenericTDT (int test, IndCategory ic=parent, bool oneHap=false, int hapPosition=1, Transmission transmissionHapPosition=t, double alpha=0.0, doubleList* externalWeights=NULL, doublevec* dT=NULL, doublevec* dU=NULL) throw (NullValue);
//double getNEntropyTDT (IndCategory ic=parent);
//double getSquareHapProbs (bool df, Transmission trans);
//double getYateTDT (double alpha=1, bool basicYate=true, IndCategory ic=parent);
//double getLaplaceTDT (double alpha=1, IndCategory ic=parent);
//double getGrouping (IndCategory ic=parent);
//long long int getMaxTDTDiff(Transmission trans);
//double getSimpleEntropyTDT (IndCategory ic=parent, int hapPosition=1, Transmission transmissionHapPosition=ut);
//int getPositionForHap (long long int hap, Transmission transmissionHapPosition);
//int solve_logreg_tdt(dv2d &trials,dv2d &successes,dv2d &design,dv2d &beta, dv2d &SE,dv2d &corr,dv2d &fitted,double *ln_like0,double *ln_like1,double tol);
//double getLogTDT(IndCategory ic=parent);

//static stringList* getHeadFileTDTFreqs();
//stringList* getTDTFreqs(Transmission t, IndCategory ic);
//stringList* getG2Results(bool g1, double pvalue, SNPPos snpPos=0);
//FreqAndKeyVector* getUsedHaplotypesInG(bool g1, Transmission trans);
//FreqAndKeyVector* getUsedHaplotypes(Transmission trans);

/**
	* Creates a vector with the non transmitted (U) haplotypes
*/
//HaplotypeVector* getNonTransmittedHaplotypes();
/**
	* Creates a vector with the transmitted (T) haplotypes
*/
//HaplotypeVector* getTransmittedHaplotypes();

//HaplotypeVector* getTUhaplotypes();

//HaplotypeVector* getTransmittedHaplotypesG1();
//HaplotypeVector* getTransmittedHaplotypesG2();
//HaplotypeVector* getNonTransmittedHaplotypesG1();
//HaplotypeVector* getNonTransmittedHaplotypesG2();


//HaplotypeVector* getHaplotypeVector(FreqAndKeyVector* hapList);



//stringList* getListOfUsedHaplotypesInG(bool g1, Transmission trans, bool onlyOneTime=true);


//stringList* getListOfUsedHaplotypes(Transmission trans, bool onlyOneTime=true);

//stringList* getTDTFreqsResults( SNPPos snpPos=-1);










