/* File: TrioGenotype.h */


#ifndef __TrioGenotype_cpp__
#define __TrioGenotype_cpp__





namespace BIOS {

ostream& operator<<(ostream& out,TrioGenotype& trio)
{

out << *trio.genotypeSample->getElement(trio.FatherGenotype)<<"\n";
out << *trio.genotypeSample->getElement(trio.MotherGenotype) <<"\n";
out << *trio.genotypeSample->getElement(trio.ChildGenotype) <<"\n";
return out;
  }


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo GenotypePointer for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 


/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/


///////////////////
//// public ////////
///////////////////

/*____________________________________________________________ */

TrioGenotype::TrioGenotype (GenotypeSample * genotypeSample)
{
this->genotypeSample=genotypeSample;
}

/*____________________________________________________________ */

TrioGenotype::TrioGenotype (GenotypeSample* genotypeSample, GenotypePointer  FatherG, GenotypePointer  MotherG, GenotypePointer  ChildG)
{
this->genotypeSample=genotypeSample;
try
{
if (FatherG==genotypeSample->end() || MotherG==genotypeSample->end() || ChildG==genotypeSample->end())
 throw NullValue();
}
 catch (NullValue nv) {nv.PrintMessage(" TrioGenotype::constructor");}

FatherGenotype=FatherG;
MotherGenotype=MotherG;
ChildGenotype=ChildG;
}

/*____________________________________________________________ */

int TrioGenotype::getInconsistencies (SNPPos SNP)
{
Genotype *motherGenotype=genotypeSample->getElement(GetMotherGenotype());
Genotype *fatherGenotype=genotypeSample->getElement(GetFatherGenotype());
Genotype *childGenotype=genotypeSample->getElement(GetChildGenotype());
Diplotype md=Diplotype(*motherGenotype->getDiplotype(SNP)), fd=Diplotype(*fatherGenotype->getDiplotype(SNP)), cg=Diplotype(*childGenotype->getDiplotype(SNP));

//cout <<"next\n ";
allele leftC, rightC, leftF, rightF, leftM, rightM;
int result=0;


leftC=cg.getLeftAllele(); rightC=cg.getRightAllele(); leftF=fd.getLeftAllele(); rightF=fd.getRightAllele(); leftM=md.getLeftAllele(); rightM=md.getRightAllele();


if (!cg.isAMissingSNP() && !md.isAMissingSNP() && !fd.isAMissingSNP())
if (leftC!=leftF && rightC!=leftF && leftC!=rightF && rightC!=rightF)
{
result++;
//if (leftC==leftF || leftC==rightF) leftC=NA; else rightC=NA;
}
if (leftC!=leftM && rightC!=leftM && leftC!=rightM && rightC!=rightM)
result++;
return result;
}

/*____________________________________________________________ */

TrioSNPGenotype TrioGenotype::getSNPGenotype (SNPPos SNP)
{
	TrioSNPGenotype r=TrioSNPGenotype(this, SNP);
	return r;
}

/*____________________________________________________________ */

GenotypePointer TrioGenotype::getGenotype (IndCategory ic)
{
switch (ic)
{
case father: 	return FatherGenotype; break;
case mother: return MotherGenotype; break;
case offspring: return ChildGenotype; break;
}
}
/*____________________________________________________________ */

GenotypePointer TrioGenotype::GetFatherGenotype ()
{
	return FatherGenotype;
}
/*____________________________________________________________ */

GenotypePointer TrioGenotype::GetMotherGenotype ()
{
	return MotherGenotype;
}
/*____________________________________________________________ */

void TrioGenotype::SetFatherGenotype (GenotypePointer genotype)
{
FatherGenotype=genotype;
}
/*____________________________________________________________ */

void TrioGenotype::SetMotherGenotype (GenotypePointer genotype)
{
MotherGenotype=genotype;
}
/*____________________________________________________________ */

void TrioGenotype::SetChildGenotype (GenotypePointer genotype)
{
ChildGenotype=genotype;
}
/*____________________________________________________________ */

void TrioGenotype::solveMIUsingChild(SNPPos SNP)
{
Genotype *motherGenotype=genotypeSample->getElement(GetMotherGenotype());
Genotype *fatherGenotype=genotypeSample->getElement(GetFatherGenotype());
Genotype *childGenotype=genotypeSample->getElement(GetChildGenotype());
Diplotype md=Diplotype(*motherGenotype->getDiplotype(SNP)), fd=Diplotype(*fatherGenotype->getDiplotype(SNP)), cg=Diplotype(*childGenotype->getDiplotype(SNP));
//cout <<"next\n ";
allele leftC, rightC, leftF, rightF, leftM, rightM;
int result=0;
leftC=cg.getLeftAllele(); rightC=cg.getRightAllele(); leftF=fd.getLeftAllele(); rightF=fd.getRightAllele(); leftM=md.getLeftAllele(); rightM=md.getRightAllele();
if (!cg.isAMissingSNP() && !md.isAMissingSNP() && !fd.isAMissingSNP())
if (leftC!=leftF && rightC!=leftF && leftC!=rightF && rightC!=rightF)
if (leftC==leftM || leftC==rightM) fd.setLeftAllele(rightC);
else if (rightC==leftM || rightC==rightM) fd.setLeftAllele(leftC);
else 
if (leftC!=leftM && rightC!=leftM && leftC!=rightM && rightC!=rightM)
if (leftC==leftF || leftC==rightF) md.setLeftAllele(rightC);
else if (rightC==leftF || rightC==rightF) md.setLeftAllele(leftC);
};
/*____________________________________________________________ */

GenotypePointer TrioGenotype::GetChildGenotype ()
{
	return ChildGenotype;
}






};  // End of Namespace

#endif

/* End of file: GenotypePointer.h */




