/* File: TrioPhenotype.h */


#ifndef __TrioPhenotype_h__
#define __TrioPhenotype_h__





namespace BIOS {


/************************/
/* SNP'S PhenotypePointer DEFINITION */
/************************/


/**
        @memo PhenotypePointer for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
class TrioPhenotype {


public:
    /** @name Implementation of class PhenotypePointer
        @memo Private part.
    */
	
	PhenotypeSample* phenotypeSample;
	PhenotypePointer FatherPhenotype, MotherPhenotype, ChildPhenotype;

   
/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */


		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:



      /** @name Operations on PhenotypePointer 
        @memo Operations on a PhenotypePointer 
    */

      /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */


		TrioPhenotype(PhenotypeSample* phenotypeSample);

		TrioPhenotype (PhenotypeSample* phenotypeSample, PhenotypePointer FatherPhenotype,  PhenotypePointer MotherPhenotype, PhenotypePointer ChildPhenotype);


      /**
	 @memo Destructor
	 @doc
           Deallocate memory used by snps.
           Time complexity O(1).

      */
      ~TrioPhenotype (){};



	  PhenotypePointer GetFatherPhenotype ();

	  PhenotypePointer GetMotherPhenotype ();

	  PhenotypePointer GetChildPhenotype ();

   PhenotypePointer GetPhenotype (IndCategory ic);

	  void SetFatherPhenotype (PhenotypePointer phenotype);

	  void SetMotherPhenotype (PhenotypePointer phenotype);

	  void SetChildPhenotype (PhenotypePointer phenotype);


	 // char* PrintPhenotype();


};  // End of class PhenotypePointer

   ostream& operator<<(ostream& out, TrioPhenotype& trioPhenotype);

//template <> ostream& operator<<(ostream& out, Container<vector, TrioPhenotype>& l){};


};  // End of Namespace

#endif

/* End of file: PhenotypePointer.h */




