/* File: TrioSNPGenotype.h */


#ifndef __TrioSNPGenotype_h__
#define __TrioSNPGenotype_h__





namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo GenotypePointer for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/


 
class TrioSNPGenotype {


public:
    /** @name Implementation of class GenotypePointer
        @memo Private part.
    */
	

	Diplotype fatherGenotype, motherGenotype, childGenotype;

	allele majorAllele;


/**
   @memo Pointer to the array of snps. It's NULL if snps has not been assigned yet.
*/


/*********************************************************************/
/***     ASSOCIATED FUNCTIONS     ***/
/*********************************************************************/

/* Head */


		/* PUBLIC FUNCTIONS (INTERFACE) */

      public:



      /** @name Operations on GenotypePointer 
        @memo Operations on a GenotypePointer 
    */

      /**
         @memo Constructor 
         @doc
          Allocate memory an initialize to null.
          Complexity O(1).

      */
		TrioSNPGenotype();

  		~TrioSNPGenotype(){};

		TrioSNPGenotype(TrioGenotype * trioGenotype, SNPPos SNP);

		TrioSNPGenotype (Diplotype fatherGenotype, Diplotype MotherGenotype, Diplotype ChildGenotype, allele majorAllele);



	  Diplotype getFatherGenotype ();

	  Diplotype getMotherGenotype ();

	  Diplotype getChildGenotype ();

	  void setFatherGenotype (Diplotype genotype);

	  void setMotherGenotype (Diplotype genotype);

	  void setChildGenotype (Diplotype genotype);

	  int getInconsistencies();


	//  string PrintGenotype(SNPPos SNP);

};  // End of class GenotypePointer

ostream& operator<<(ostream& out,TrioSNPGenotype& trio);


//template<> ostream& operator<<(ostream& out, Container<vector,TrioGenotype>& l){};







};  // End of Namespace

#endif

/* End of file: GenotypePointer.h */




