/* File: TrioSample.h */


#ifndef __TrioSample_cpp__
#define __TrioSample_cpp__

//#include <string.h>
//#include <cstdio>


//#include "GenomaSample.cpp"

//#include "CoupleGenotype.h"
namespace BIOS {


/************************/
/* SNP'S GENOTYPE DEFINITION */
/************************/


/**
        @memo Genotype for SNPs

	@doc
        Definition:
        A unordered pair of SNPs values for an individual and a genetic position.
        One has been transmitted from the father, one for the mother. Who transmits
        each one of them does not matter.

        Memory space: O(1). 

        @author Maria M. Abad
	@version 1.0
*/
template <> Trio* Container<vector<Trio*>, Trio*>::readElement (ifstream * source, const char* tokens, int* pos, int size) {
cout << "Trio* Container<vector, Trio*>::readElement not implemented  yet";
end();
};

/**********************************/
/* DEFINITIONS OF THE FUNCTIONS */
/**********************************/

//////////// privates /////////////
 /*____________________________________________________________ */

void TrioSample::InitializeTrioSample ()
{
try
{
bool *children=NULL;
if (TrioList!=NULL)
{
if (genotypeSample!=NULL)
{
if (solveMIUsingChildren) solveMendelianInconsistenciesUsingChildren();
CheckInconsistenciesFromParents();
}
if (phenotypeSample!=NULL && genotypeSample!=NULL)
{

 switch (genotypeSample->AlleleOrderMode)
 {
 case NotChanged: break;
 case MajorFirst: break; // already done in GenotypeSample
 case random: break;
 case LeftRight: //break;
 case LeftRightUsingTrios: OrderLeftRight(); break;
 };	
	if (CompleteMissing) completeMissing();
 IndPos TotalInds=phenotypeSample->size();
 setMarked(parent);

 children=Initialize(phenotypeSample->size(), true);
 phenotypeSample->SetMarked(children, offspring); 
 genotypeSample->setAllAlleles(Marked, children);	// children are used to keep missing in children have a missing value
 zaparr(children);
}
}
}
catch (BasicException& be){be.addMessage("\ncalled from TrioSample::initializeTrioSample");throw;};
}
/*____________________________________________________________ */

void TrioSample::CreateTrioList ()
{
try
{
//cout <<"bfff\n";
 Trio *T; //=new Trio(phenotypeSample, genotypeSample);
 if (genotypeSample!=NULL)
 {
 TrioList=new Container<vector<Trio*>, Trio*>();
 GenotypeSample::iterator IndGenotype=genotypeSample->getFirst();
 PhenotypeSample::iterator IndPhenotype=phenotypeSample->getFirst();
 while (IndGenotype!=genotypeSample->end() && IndPhenotype!=phenotypeSample->end())
  {
 
if (phenotypeSample->getElement(IndPhenotype)->IsAFather())
   {
//cout << "F: " << *genotypeSample->getElement(IndGenotype)->getDiplotype(7) <<" and " << *genotypeSample->getElement(IndGenotype)->getDiplotype(8) <<"\n";


   T=GetTrioMembers(IndPhenotype, IndGenotype);
   //cout <<*T <<"\n";
   TrioList->insertElement(T);
   }
//else cout <<"non a father\n";
// if (phenotypeSample->getElement(IndPhenotype)->IsAMother())
//  cout << ":M " << *genotypeSample->getElement(IndGenotype)->getDiplotype(7) <<" and " << *genotypeSample->getElement(IndGenotype)->getDiplotype(8) <<"\n";


   IndGenotype=genotypeSample->getNext(IndGenotype);
   IndPhenotype=phenotypeSample->getNext(IndPhenotype);
 }
//cout <<"end\n";
//exit(0);
}
//cout <<"las\n";
}
catch (BasicException& be){be.addMessage("\ncalled from TrioSample::CreateTrioList()"); throw;};
}

/*__________________________________________________________________*/


SNPPos TrioSample::getTotalSNPs()
{
try
{
return genotypeSample->GetTotalSNPs();
}
catch (BasicException& be){be.addMessage("\ncalled from TrioSample::getTotalSNPs()"); throw;};
}
/*__________________________________________________________________*/

void TrioSample::OrderLeftRight ()
{
//try
//{
int cont=0;
if (TrioList!=NULL)
{
// order alleles in the trio for offspring to be consistent with parents
  Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
  Genoma* G;
  SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();

while (TrioPos!=TrioList->end())
  {
   for (unsigned short int i=0;i<3;i++)
   {	 
   G=new Genoma(TrioList->getElement(TrioPos), (IndCategory)i);
   for (SNPPos SNP=0; SNP<TotalSNPs;SNP++)
 if (genotypeSample->AlleleOrderMode==LeftRightUsingTrios)
{
if (G->getDiplotype(SNP)->isANonMissingSNP())
    if (G->CanBeInferred(SNP, NotChanged)) // if not missing and at least one person is homozygotic
	{
  	 if (G->MustBeChanged(SNP))
	  G->ChangeAlleles(SNP);
	}
	else if (G->getDiplotype(SNP)->isHeterozygous()) G->markAlleles(SNP);
   }
else // LeftRight
{
if (!allowRecombination)
{

if ((IndCategory)i==offspring) 
{
if (G->getDiplotype(SNP)->getLeftAllele()!=G->getPairGenotype()->getFirstGenotype()->getDiplotype(SNP)->getLeftAllele())
{
cout << *G->getDiplotype(SNP) << " and parent: " << *G->getPairGenotype()->getFirstGenotype()->getDiplotype(SNP);
cout <<"\nfamily:" << cont+1 <<" and SNP: " << SNP+1;
throw Inconsistent("TrioSample::OrderLeftRightFather");
}
//G->ChangeAlleles(SNP);
if (G->getDiplotype(SNP)->getRightAllele()!=G->getPairGenotype()->getSecondGenotype()->getDiplotype(SNP)->getLeftAllele())
{
cout << *G->getDiplotype(SNP) << " and parent: " << *G->getPairGenotype()->getSecondGenotype()->getDiplotype(SNP);
cout <<"\nfamily:" << cont+1 <<" and SNP: " << SNP+1;
throw Inconsistent("TrioSample::OrderLeftRightMother");
}
}
}
//G->ChangeAlleles(SNP);

}
zap(G);
   }
   TrioPos=TrioList->getNext(TrioPos);
cont++;
  }

 //   cout <<"Sorting left right has finished\n";
}
//}
//catch (Inconsistent&ic) {ic.PrintMessage(); cout <<"\n"; throw;};
}
///////////////////
//// public ////////
///////////////////


TrioSample* TrioSample::clone()
{
return new TrioSample(*this);
}
 
/***************************************************/

TrioSample::~TrioSample ()
{

zap(TrioList); 
zaparr(inconsistencies);
zaparr(nonHeteroParents); 
zaparr(parentsNotInHWE); 
zaparr(childrenNotInHWE);
};

/***************************************************/

TrioSample::TrioSample(char* filename, int*pos, int size, AlleleOrderType AlleleOrderMode, bool CompleteMis, bool allowRecombination, bool solveMIUsingChildren): GenomaSample(filename, pos, size, parent, AlleleOrderMode) 
{
try
{
this->solveMIUsingChildren=solveMIUsingChildren;
TrioList=NULL;
CompleteMissing=CompleteMis;
inconsistencies=NULL;
nonHeteroParents=NULL;
parentsNotInHWE=NULL;
childrenNotInHWE=NULL;
this->allowRecombination=allowRecombination;
//cout <<"beforeCreateTrioList\n";
CreateTrioList();
//cout <<"InitializeTrioSample\n";
InitializeTrioSample();
//cout <<"afterInitializeTrioSample\n";
}
catch (BasicException& be){be.addMessage("\ncalled from TrioSample::TrioSample (char * filename,..."); throw;};
}
/*____________________________________________________________ */
/*
TrioSample::TrioSample (TrioSample& source, Container<vector<IndPos>, IndPos>* Sampling)
{
cout <<"TrioSample::TrioSample (TrioSample& source, Container<vector<IndPos>, IndPos>* Sampling) no implemented. Try TrioSample::TrioSample (TrioSample& source, Container<set<IndPos>, IndPos>* Sampling)";
exit(0);
}

/*____________________________________________________________ */

void TrioSample::copy(TrioSample& source)
{
try
{
allowRecombination=source.allowRecombination;
CompleteMissing=source.CompleteMissing;
solveMIUsingChildren=source.solveMIUsingChildren;
init();
}
catch (Inconsistent& ic) {ic.addMessage("\ncalled from TrioSample::copy(TrioSample& source"); throw;}
catch (BasicException& be) {be.addMessage("\ncalled from TrioSample::copy(TrioSample& source"); throw;};
}

/*____________________________________________________________ */

void TrioSample::init()
{
 TrioList=NULL;
inconsistencies=NULL;
nonHeteroParents=NULL;
parentsNotInHWE=NULL;
childrenNotInHWE=NULL;
 CreateTrioList();
 InitializeTrioSample();
}
/*____________________________________________________________ */

TrioSample::TrioSample (TrioSample& source, Container<set<string>, string>* selectedPositions, char* filePos) throw (Inconsistent&): GenomaSample(source, selectedPositions, filePos)
{
try
{
copy(source);
}
catch (Inconsistent& ic){ic.addMessage("\ncalled from TrioSample::TrioSample (TrioSample& source, Container<set<string>, string>* selectedPositions, char* filePos)"); throw;}
catch (BasicException& be){be.addMessage("\ncalled from TrioSample::TrioSample (TrioSample& source, Container<set<string>, string>* selectedPositions, char* filePos)"); throw;};
}
/*____________________________________________________________ */
/*
void TrioSample::setWithSelection(TrioSample& source, Container<set<IndPos>, IndPos>* Sampling)
{

Trio*T;
intList *trioP, *trioG; 
for (int i=TrioList->size()-1; i>=0; i--)
if (Sampling->findElement(i)==Sampling->end())
{
T=TrioList->getElement(i);
trioP=new intList();
trioG=new intList();
if (T->getFatherGenotype()==genotypeSample->end()) cout <<"fathernul\n";
trioG->insertElement(genotypeSample->getPosition(T->getFatherGenotype()));
trioG->insertElement(genotypeSample->getPosition(T->getMotherGenotype()));
trioG->insertElement(genotypeSample->getPosition(T->getChildGenotype()));
trioG->sort(false);
trioP->insertElement(phenotypeSample->getPosition(T->getFatherPhenotype()));
trioP->insertElement(phenotypeSample->getPosition(T->getMotherPhenotype()));
trioP->insertElement(phenotypeSample->getPosition(T->getChildPhenotype()));
trioP->sort(false);
for (int c=0; c<3; c++)
{
	genotypeSample->removeNode(trioG->getElement(c));
	phenotypeSample->removeNode(trioP->getElement(c));
}
	TrioList->removeNode(i);
delete(trioG);
delete trioP;
}
if (currentIc!=nobody) 
setMarked(currentIc); 
}
/*____________________________________________________________ */
/*
TrioSample::TrioSample (TrioSample& source, Container<set<IndPos>, SNPPos>* Sampling): GenomaSample(source)
{
setWithSelection(source, Sampling);
}
/*____________________________________________________________ */

TrioSample::TrioSample (TrioSample& source, Container<set<SNPPos>, SNPPos>* Sampling, bool selectInds): GenomaSample()
{
intSet* samp2=Sampling;
if (selectInds)
{
samp2=new intSet();
intList *trioP, *trioG; 
for (Container<vector<Trio*>, Trio*>::iterator it=source.TrioList->begin(); it!=source.TrioList->end(); it++)
if (Sampling->findElement(source.TrioList->getPosition(it))!=Sampling->end())
{
samp2->insertElement(source.genotypeSample->getPosition(((Trio*)*it)->getFatherGenotype()));
samp2->insertElement(source.genotypeSample->getPosition(((Trio*)*it)->getMotherGenotype()));
samp2->insertElement(source.genotypeSample->getPosition(((Trio*)*it)->getChildGenotype()));
}
}
GenomaSample::copy(source, samp2, selectInds);
if (selectInds) zap(samp2);
copy(source);
}
/*____________________________________________________________ */
/*
TrioSample::TrioSample (TrioSample& source, Container<set<IndPos>, SNPPos>* Sampling, bool): GenomaSample(source, Sampling)
{
setWithSelection(source, Sampling);
}
/*____________________________________________________________ */
/*
TrioSample::TrioSample (TrioSample& source, Container<set<IndPos>, IndPos>* Sampling, bool selectInds): GenomaSample(source)
{
copy(source);
if (Sampling!=NULL) setWithSelection(source, Sampling);
}
/*____________________________________________________________ */
/*
TrioSample::TrioSample (GenomaSample& Source, bool CompleteMis): GenomaSample(Source)
{
basicSet(CompleteMis);

}
/*____________________________________________________________ */

TrioSample::TrioSample (PhenotypeSample& SourceP, GenotypeSample& SourceG): GenomaSample(SourceP, SourceG)
{
init();
}


/*____________________________________________________________ */

void TrioSample::setAffectationRandomly ()
{
GenomaSample::setAffectationRandomly();
}


/*____________________________________________________________ */

TrioSample* TrioSample::permute ()
{
TrioSample* trioSample=this->clone();
if (trioSample->TrioList==NULL || trioSample->genotypeSample==NULL  || (trioSample->genotypeSample->AlleleOrderMode!=LeftRight && trioSample->genotypeSample->AlleleOrderMode!=LeftRightUsingTrios)) return trioSample; 
Container<vector<Trio*>, Trio*>::iterator TrioPos=trioSample->TrioList->getFirst();
Genoma*childG, *G;
SNPPos TotalSNPs=trioSample->genotypeSample->GetTotalSNPs();
int recomb;
while (TrioPos!=trioSample->TrioList->end())
  {
   for (unsigned short int i=0;i<2;i++) // only for parents
   {	 
   recomb=ranbinom(1, 0.5);
   if (recomb)
   {
   childG=new Genoma(trioSample->TrioList->getElement(TrioPos), offspring);
	G=new Genoma(trioSample->TrioList->getElement(TrioPos), (IndCategory)i);
   for (SNPPos SNP=0; SNP<TotalSNPs;SNP++)
{
    if (G->CanBeInferred(SNP, NotChanged)) // if not missing and at least one person is homozygotic
    if (G->getGenotype()->isHeterozygous(SNP)) 
	 {
/*
if (i==1)
{
cout <<"\bfefore SNP:"  << SNP << "\n:";
cout << *childG->getDiplotype(SNP) << " and father: " << *childG->getPairGenotype()->getFirstGenotype()->getDiplotype(SNP)
<< " and mother: " << *childG->getPairGenotype()->getSecondGenotype()->getDiplotype(SNP);

cout <<"\n";
}
*/
   childG->changeTransmittedAlleles(SNP, !i);
/*
if (i==1)
{
cout <<"\nafter\n:";
cout << *childG->getDiplotype(SNP) << " and father: " << *childG->getPairGenotype()->getFirstGenotype()->getDiplotype(SNP)
<< " and mother: " << *childG->getPairGenotype()->getSecondGenotype()->getDiplotype(SNP);
cout <<"\n";
exit(0);
}
*/
}

   }
  zap(childG);
zap(G);
}
   }
   TrioPos=trioSample->TrioList->getNext(TrioPos);
   }
return trioSample;
}
/*____________________________________________________________ */

void TrioSample::CheckParentsHWE ()
{
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
double observed[2], expected[2];
if (parentsNotInHWE==NULL) parentsNotInHWE=Initialize(TotalSNPs, 0);
for (SNPPos SNP=0;SNP<TotalSNPs;SNP++)
{
observed[0]=GetTotalAllele (SNP, (allele)1, father);
observed[1]=GetTotalAllele (SNP, (allele)1, mother);
expected[0]=(observed[0]+observed[1])/(double)2;
expected[1]=(observed[0]+observed[1])/(double)2;
if (chiTest(observed, expected, 1)<0.05) parentsNotInHWE[SNP]=1;
}
}
/*____________________________________________________________ */

void TrioSample::CheckChildrenHWE ()
{
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
if (childrenNotInHWE==NULL) childrenNotInHWE=Initialize(TotalSNPs, 0);
for (SNPPos SNP=0;SNP<TotalSNPs;SNP++)
if (parentsNotInHWE==NULL || parentsNotInHWE[SNP]==0)
{
if (getChildrenHWETest(SNP)<0.05) childrenNotInHWE[SNP]=1;
}
else childrenNotInHWE[SNP]=2;
}

/*____________________________________________________________ */

double TrioSample::getChildrenHWETest (SNPPos SNP)
{
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
double observed[3], expected[3], allele[2];
double allele1, allele2, total1, total2;
observed[0]=GetTotalHomozygous1 (SNP, offspring);
observed[1]=GetTotalHomozygous2 (SNP, offspring);
observed[2]=GetTotalHeterozygous (SNP, offspring);
total1=observed[0]+observed[1]+observed[2];
//if (total1==0) throw NanValue("TrioSample::getChildrenHWETest");
allele[0]=GetTotalAllele (SNP, genotypeSample->allAlleles[SNP][0], parent);
allele[1]=GetTotalAllele (SNP, genotypeSample->allAlleles[SNP][1], parent);
total2=allele[0]+allele[1];
expected[0]=total1*std::pow(allele[0]/total2,2);
expected[1]=total1*std::pow(allele[1]/total2,2);
expected[2]=total1*(allele[0]/total2)*(allele[1]/total2)*2;
if (expected[0]==0 || expected[1]==0 || expected[2]==0)
throw NanValue(" TrioSample2::getChildrenHWETest");
return chiTest(observed, expected, 2);
}

/*____________________________________________________________ */

int TrioSample::getNonHeteroParents (SNPPos SNP)
{
int nonHeteroParents=0;
Trio *T;
Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
while (TrioPos!=TrioList->end())
{
T=TrioList->getElement(TrioPos);

if (!T->genotypeSample->getElement(T->getFatherGenotype())->getDiplotype(SNP)->isAMissingSNP() &&
!T->genotypeSample->getElement(T->getMotherGenotype())->getDiplotype(SNP)->isAMissingSNP() &&
!T->genotypeSample->getElement(T->getChildGenotype())->getDiplotype(SNP)->isAMissingSNP())
{
 if (!T->genotypeSample->getElement(T->getFatherGenotype())->getDiplotype(SNP)->isHeterozygous())
nonHeteroParents++;
 if (!T->genotypeSample->getElement(T->getMotherGenotype())->getDiplotype(SNP)->isHeterozygous()) nonHeteroParents++;
}
TrioPos=TrioList->getNext(TrioPos);
}	
return nonHeteroParents;
}

/*____________________________________________________________ */

void TrioSample::solveMendelianInconsistenciesUsingChildren ()
{
Trio *T;
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();	
for (SNPPos SNP=0;SNP<TotalSNPs;SNP++)
{
Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
while (TrioPos!=TrioList->end())
{
T=TrioList->getElement(TrioPos);
if (T->trioGenotype->getInconsistencies(SNP)>0)
T->trioGenotype->solveMIUsingChild(SNP);	
TrioPos=TrioList->getNext(TrioPos);
}	
}
}
/*____________________________________________________________ */

int TrioSample::getInconsistenciesFromParents (SNPPos SNP)
{
Trio *T;
Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
int totalInconsistencies=0;
while (TrioPos!=TrioList->end())
{
T=TrioList->getElement(TrioPos);
totalInconsistencies=totalInconsistencies+T->trioGenotype->getInconsistencies(SNP);	
TrioPos=TrioList->getNext(TrioPos);
}	
return totalInconsistencies;
}

/*____________________________________________________________ */

void TrioSample::CheckInconsistenciesFromParents ()
{
//cout << "Checking inconsistencies from parents...\n";
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();	
inconsistencies=Initialize(TotalSNPs, 0);
nonHeteroParents=Initialize(TotalSNPs, 0);
for (SNPPos SNP=0;SNP<TotalSNPs;SNP++)
{
inconsistencies[SNP]=getInconsistenciesFromParents(SNP);
nonHeteroParents[SNP]=getNonHeteroParents(SNP);
}
}
/*____________________________________________________________ */

void TrioSample::completeMissing ()
{
//cout << "\nCompleting missing...";
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();	
Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
Trio *T;
//allele MinorAllele;
Diplotype* D, *relative1D, *relative2D;
Genoma* G;
PairGenotype* PG;
while (TrioPos!=TrioList->end())
{
 T=TrioList->getElement(TrioPos);
for (int i=0; i<3; i++)
{
	G=new Genoma(TrioList->getElement(TrioPos), (IndCategory)i);
 PG=G->getPairGenotype();
  for (SNPPos SNP=0;SNP<TotalSNPs;SNP++)
{
  D=G->getGenotype()->getDiplotype(SNP);
relative1D=PG->getFirstGenotype()->getDiplotype(SNP);
relative2D=PG->getSecondGenotype()->getDiplotype(SNP);
  if (D->isAMissingSNP())
   {
/*    if (!relative1D->isAMissingSNP() && relative1D->isHomozygous2 (genotypeSample->allAlleles[SNP][0]))
		   MinorAllele=relative1D->getLeftAllele();
	else
    if (!relative2D->isAMissingSNP() && relative2D->isHomozygous2 (genotypeSample->allAlleles[SNP][0]))
		   MinorAllele=relative2D->getLeftAllele();
   */
 if (!relative1D->isAMissingSNP() && !relative2D->isAMissingSNP())
{
	if (PG->IsHomozygous1Homozygous1 (SNP, genotypeSample->allAlleles)) 
	   D->setAlleles(genotypeSample->allAlleles[SNP][0], genotypeSample->allAlleles[SNP][0]);

    if (PG->IsHomozygous2Homozygous2 (SNP, genotypeSample->allAlleles)) 
	   D->setAlleles(genotypeSample->allAlleles[SNP][1], genotypeSample->allAlleles[SNP][1]);

    if (PG->IsHomozygous1Homozygous2 (SNP, genotypeSample->allAlleles)) 
       D->setAlleles(genotypeSample->allAlleles[SNP][0], genotypeSample->allAlleles[SNP][1]);
}
  } // end for each missing SNP
}
 zap(G);
}
 TrioPos=TrioList->getNext(TrioPos);
} // end for each trio
//cout <<"\nMissing data have been completed from parents\n";
}

/*__________________________________________________________*/

SNPPos TrioSample::getTotalType (SNPPos SNP, IndCategory ic, int genotypeValue, int gender, int affectation)
{
bool Marked[phenotypeSample->size()];
setMarked(ic, gender, affectation);
return genotypeSample->getTotalType(SNP, genotypeValue, Marked);
}
/*___________________________________________________________*/

SNPPos TrioSample::GetTotalHomozygous1 (SNPPos SNP, IndCategory ic, int gender, int affectation)
{
allele allele1=getMajorAllele(SNP, ic, gender, affectation);
	return getTotalType (SNP, ic, getPosGenotype((int)allele1, (int)allele1, genotypeSample->totalAlleles[SNP]), gender, affectation);
}
/*___________________________________________________________*/

SNPPos TrioSample::GetTotalHomozygous2 (SNPPos SNP, IndCategory ic, int gender, int affectation)
{
allele allele1=getMinorAllele(SNP, ic, gender, affectation);

	return getTotalType (SNP, ic, getPosGenotype((int)allele1, (int)allele1, genotypeSample->totalAlleles[SNP]), gender, affectation);
}
/*___________________________________________________________*/

SNPPos TrioSample::GetTotalHeterozygous (SNPPos SNP, IndCategory ic, int gender, int affectation)
{
allele allele1=getMajorAllele(SNP, ic, gender, affectation);
allele allele2=getMinorAllele(SNP, ic, gender, affectation);
	return getTotalType (SNP, ic, getPosGenotype((int)allele1, (int)allele2, genotypeSample->totalAlleles[SNP]), gender, affectation);
}
/*___________________________________________________________*/
/*
SNPPos TrioSample::GetTotalMissing (SNPPos SNP, IndCategory ic, int gender, int affectation)
{
	return GetTotalType (SNP, ic, missing, gender, affectation);
}
/*___________________________________________________________*/
/*
SNPPos TrioSample::GetTotalNonMissing (SNPPos SNP, IndCategory ic, int gender, int affectation)
{
	return GetTotalHomozygous1 (SNP, ic, gender, affectation)+GetTotalHomozygous2(SNP, ic)+GetTotalHeterozygous(SNP, ic, gender, affectation);
}
/*__________________________________________________________*/

SNPPos TrioSample::GetTotalAllele (SNPPos SNP, allele allele1, IndCategory ic, int gender, int affectation)
{
//bool Marked[phenotypeSample->size()];
setMarked(ic, gender, affectation);
//for (int i=0;i<GetTotalSNPs();i++)
//cout <<"\n" << Marked[i];
//cout <<"total al:" << genotypeSample->GetTotalAllele(SNP, false, Marked);
//end();
return genotypeSample->GetTotalAllele(SNP, allele1, Marked);
}
/*__________________________________________________________*/

SNPPos TrioSample::getTotalTrios ()
{
return TrioList->size();
}

/*__________________________________________________________*/

SNPPos TrioSample::size ()
{
return getTotalTrios();
}


/*____________________________________________________________ */
/*
SNPPos TrioSample::GetDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, IndCategory ic=everybody, int gender, int affectation)
{
//bool Marked[phenotypeSample->size()];
setMarked(ic, gender, affectation);
return genotypeSample->getDoubleHeterozygous(FirstSNP, LastSNP, i, j, Marked);
}
/*____________________________________________________________ */
/*
SNPPos TrioSample::GetUnsolvedDoubleHeterozygous (SNPPos FirstSNP, SNPPos LastSNP, MultiallelicHetero i, MultiallelicHetero j, IndCategory ic, bool IsPartiallySolved, int gender, int affectation)
{
setMarked(ic, gender, affectation);
IndPos TotalInds=0;
TotalInds=genotypeSample->GetUnsolvedDoubleHeterozygous(FirstSNP, LastSNP, i, j, genotypeSample->AlleleOrderMode, Marked);
//cout <<" totalidns is\n";
//cout  << TotalInds <<" \n" ;
if (TotalInds>0)
{
Container<vector, Trio*>::iterator TrioPos=TrioList->getFirst();
Genoma* G;
Phenotype *phen;
bool coupleAffectation=false;
while (TrioPos!=TrioList->end())
{
for (int k=0; k<=2; k++)
{
if (ic==(IndCategory)k || ic==everybody || (ic==parent && k<2))
{
switch (k)
{
case 0: phen=phenotypeSample->getElement(TrioList->getElement(TrioPos)->getFatherPhenotype()); 
if ((phenotypeSample->getElement(TrioList->getElement(TrioPos)->getMotherPhenotype())->getAffectation()==phen->getAffectation())
|| affectation==allAffectation) coupleAffectation=true;
break;
case 1: phen=phenotypeSample->getElement(TrioList->getElement(TrioPos)->getMotherPhenotype()); 
if ((phenotypeSample->getElement(TrioList->getElement(TrioPos)->getFatherPhenotype())->getAffectation()==phen->getAffectation())
|| affectation==allAffectation) coupleAffectation=true;
break;
case 2: phen=phenotypeSample->getElement(TrioList->getElement(TrioPos)->getChildPhenotype()); 
if (((phenotypeSample->getElement(TrioList->getElement(TrioPos)->getFatherPhenotype())->getAffectation()==phen->getAffectation())
&& (phenotypeSample->getElement(TrioList->getElement(TrioPos)->getMotherPhenotype())->getAffectation()==phen->getAffectation()))
|| affectation==allAffectation) coupleAffectation=true;
break;
}
if (phen->GetPhenotype().Gender==gender || gender==everyGender)
if (phen->getAffectation()==affectation || affectation==allAffectation)
{
	G=new Genoma(TrioList->getElement(TrioPos), (IndCategory)k);
        if (G->getGenotype()->IsHeterozygousHeterozygous (FirstSNP, LastSNP, i, j, genotypeSample->allAlleles[FirstSNP], genotypeSample->allAlleles[LastSNP], genotypeSample->totalAlleles[FirstSNP], genotypeSample->totalAlleles[LastSNP])) 
	if (G->CanBeInferred(FirstSNP, LastSNP, genotypeSample->AlleleOrderMode) || (gender==everyGender && coupleAffectation && G->CanBePartiallySolved(FirstSNP, LastSNP, IsPartiallySolved)))
	TotalInds--;
	delete G;
}
}
}
TrioPos=TrioList->getNext(TrioPos);
}
}
return TotalInds;
}
/*____________________________________________________________ */

TrioSample* TrioSample::shuffleTransmissions ()
{
// solve phase assigning that with maxFreq (PhaseAlg=maxFreq)
try
{
TrioSample* result=new TrioSample(*this);
if (result->TrioList!=NULL)
{
  Container<vector<Trio*>, Trio*>::iterator TrioPos=result->TrioList->getFirst();
  GenotypeSample::iterator GFather, GMother, GChild, G;
  SNPPos TotalSNPs=result->genotypeSample->GetTotalSNPs();
  allele parentAllele;

bool shuffleFather, shuffleMother;
while (TrioPos!=result->TrioList->end())
  {
   shuffleFather=(bool)ranbinom ( 1, 0.5 );
   shuffleMother=(bool)ranbinom ( 1, 0.5 );
   GFather=result->TrioList->getElement(TrioPos)->getFatherGenotype();
   GMother=result->TrioList->getElement(TrioPos)->getMotherGenotype();
   GChild=result->TrioList->getElement(TrioPos)->getChildGenotype();
   for (unsigned short int i=0;i<3;i++)
   {	 
   switch (i)
   {case 0: G=GFather; break;
    case 1: G=GMother; break;
    case 2: G=GChild; break;}
   for (SNPPos SNP=0; SNP<TotalSNPs;SNP++)
   {
    if ((i==0 && shuffleFather) || (i==1 && shuffleMother))
	  result->genotypeSample->getElement(G)->ChangeAlleles(SNP);
   if (i==2 && shuffleFather) result->genotypeSample->getElement(G)->getDiplotype(SNP)->setLeftAllele(result->genotypeSample->getElement(GFather)->getDiplotype(SNP)->getLeftAllele());
   if (i==2 && shuffleMother) result->genotypeSample->getElement(G)->getDiplotype(SNP)->setRightAllele(result->genotypeSample->getElement(GMother)->getDiplotype(SNP)->getLeftAllele());
	}
   }
   TrioPos=result->TrioList->getNext(TrioPos);
 }

 //   cout <<"Sorting left right has finished\n";
}
return result;
}
catch (BasicException & be) {be.addMessage("\ncalled from TrioSample::shuffleTransmissions"); throw;};
} 


/*____________________________________________________________ */

TrioSample* TrioSample::solvePhase (EMDistributions emDistributions, EMRestriction emRestriction, int windowSize)
{
// solve phase assigning that with maxFreq (PhaseAlg=maxFreq)
try
{
//cout <<"inisolvephase\n";
SNPPos TotalSNPs=genotypeSample->GetTotalSNPs();
bool onlyHetero=false, includeMissing=true;
//cout <<"inisolvephase2\n";
TrioSample* result=new TrioSample(*this);

//cout <<"inisolvephase3\n";


TrioCountersHapUAndT*TM=NULL;
int *pos=NULL, size, trioCont=0, * motherT, *motherU, *fatherT, *fatherU;
Genotype* G;
SNPPos SNP=0, SNP2=0;
ParentalHaplotypes* haplotypes;
SlidingWindows *sw=new SlidingWindows(windowSize, windowSize, TotalSNPs);
int totalWindows=sw->getTotalWindows();
TrioCounters* tc;
//cout <<"toatlwiowis:" << totalWindows <<"\n";
//cout <<"inisolvephase4\n";
//cout << "total snos:" << TotalSNPs <<"\ntotal windows: " << totalWindows <<"\n";
//cout <<"totalcompletewindows:" << sw->getTotalCompleteWindows() <<"\n";;
for (int i=0; i<totalWindows;i++)
{
trioCont=0;
size=sw->getSizeOfWindow(i);
cout <<"window " << i+1 <<" out of " << totalWindows << "\n";
//cout <<"size is:" << size <<"\n";
pos=new int[size];
for (int j=0; j<size; j++) 
{
pos[j]=SNP+j;
if (pos[j]<0 || pos[j]>=TotalSNPs) throw OutOfBounds(pos[j], TotalSNPs, "TrioSample::solvePhase");
}
tc=new TrioCounters(pos, size, result, allAffectation, includeMissing);
TM = new TrioCountersHapUAndT (tc, maxFreq, emDistributions, emRestriction);
for (Container<vector<Trio*>, Trio*>::iterator it=result->TrioList->getFirst(); it<result->TrioList->end(); it++)
{
if (TM->haplotypeCounts->getElement(trioCont)!=NULL)
{
haplotypes=TM->haplotypeCounts->getElement(trioCont);
motherT=TM->haplotypeTable->getPositions(haplotypes->motherT);
fatherT=TM->haplotypeTable->getPositions(haplotypes->fatherT);
motherU=TM->haplotypeTable->getPositions(haplotypes->motherU);
fatherU=TM->haplotypeTable->getPositions(haplotypes->fatherU);
for (int ind=0; ind<3; ind++) // father, mother, offspring
{
SNP2=SNP;
G=result->getGenotype(it, (IndCategory)ind);
for (int j=0; j<size; j++) 
{
if (SNP2<0 || SNP2>=TotalSNPs) throw OutOfBounds(SNP2, TotalSNPs, "2. TrioSample::solvePhase");
if (fatherT[j]<0 || fatherT[j]>=genotypeSample->totalAlleles[SNP2]) throw OutOfBounds(fatherT[j], genotypeSample->totalAlleles[SNP2], "3. TrioSample::solvePhase");
if (fatherU[j]<0 || fatherU[j]>=genotypeSample->totalAlleles[SNP2]) throw OutOfBounds(fatherU[j], genotypeSample->totalAlleles[SNP2], "3. TrioSample::solvePhase");
if (motherT[j]<0 || motherT[j]>=genotypeSample->totalAlleles[SNP2]) throw OutOfBounds(motherT[j], genotypeSample->totalAlleles[SNP2], "3. TrioSample::solvePhase");
if (motherU[j]<0 || motherU[j]>=genotypeSample->totalAlleles[SNP2]) throw OutOfBounds(motherU[j], genotypeSample->totalAlleles[SNP2], "3. TrioSample::solvePhase");
switch (ind)
{
case 0: // father
G->SetAlleles(genotypeSample->allAlleles[SNP2][fatherT[j]], genotypeSample->allAlleles[SNP2][fatherU[j]], SNP2); break;
case 1: // mother
G->SetAlleles(genotypeSample->allAlleles[SNP2][motherT[j]], genotypeSample->allAlleles[SNP2][motherU[j]], SNP2); break;
case 2: // offspring
G->SetAlleles(genotypeSample->allAlleles[SNP2][fatherT[j]], genotypeSample->allAlleles[SNP2][motherT[j]], SNP2); break;
}
SNP2++;
}
}
zaparr(motherT);zaparr(fatherT);zaparr(motherU);zaparr(fatherU);
}
trioCont++;
if (it==(result->TrioList->end()-1)) SNP=SNP+size;
}
zap(TM);
zap(tc);
zaparr(pos);
}
zap(sw);
return result;
}
catch (BasicException & be) {be.addMessage("\ncalled from 3 TrioSample::solvePhase"); throw;};
} 


/*____________________________________________________________ */

Genotype* TrioSample::getGenotype(Container<vector<Trio*>, Trio*>::iterator TrioPos, IndCategory ind)
{
return ((GenotypeSample*)this)->getElement(TrioList->getElement(TrioPos)->getGenotype(ind));
}



/*____________________________________________________________ */

longLongList* TrioSample::getGenotypeCounts (const SNPPos *pos, int totalPos, IndCategory ic, int gender, int affectation, AmbiguousArray* tableGenotypes, bool onlyHetero, bool includeMissing)  
{
// It returns a list of the genotype codes of all the individuals in the sample who match ic, gender, affectation, onlyHetero and includeMissing
try
{
long long int position;
longLongList* result=new longLongList();
//cout <<"number of trios:" << TrioList->size();
Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst();
Genotype* G;
Phenotype *phen;
int current=0, SNP;
Trio* T;
bool missing;
for (Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst(); TrioPos!=TrioList->end(); TrioPos++)
{
T=TrioList->getElement(TrioPos);
missing=false;
for (int i=0; i<totalPos; i++)
{
SNP=pos[i];
if (T->genotypeSample->getElement(T->getFatherGenotype())->getDiplotype(SNP)->isAMissingSNP() ||
T->genotypeSample->getElement(T->getMotherGenotype())->getDiplotype(SNP)->isAMissingSNP() ||
T->genotypeSample->getElement(T->getChildGenotype())->getDiplotype(SNP)->isAMissingSNP())
missing=true;
}
//if (!missing || includeMissing)
for (int i=0; i<=2; i++) // 0 is father, 1 is mother
{
if (ic==(IndCategory)i || ic==everybody || (ic==parent && i<2))
{
phen=phenotypeSample->getElement(T->getPhenotype((IndCategory)i)); 
if (phen->GetPhenotype().Gender==gender || gender==everyGender)
if (phen->getAffectation()==affectation || affectation==allAffectation)
{
G=getGenotype(TrioPos, (IndCategory)i);
//cout << "pos is:" << *pos <<", totalPos is: " << totalPos <<", includemissing" << includeMissing <<"\n";
position=G->getGenotypeCounts(pos, totalPos, genotypeSample->allAlleles, genotypeSample->totalAlleles, tableGenotypes, genotypeSample->AlleleOrderMode, onlyHetero, includeMissing);   
//cout <<"\npos is "<<position <<" for genotype " << *G;
//if (position>=0) 
result->insertElement(position);
}
}
}
current++;
}
return result;
}
catch (BasicException & be) {be.addMessage("\ncalled from TrioSample::getGenotypeCounts"); throw;};
}
/*____________________________________________________________ */

VectorOfParentalGenotypes* TrioSample::getGenotypeCounts (const SNPPos *pos, int totalPos)  
{
// It returns a list of parental genotypes
try
{
//BIOS::print((int*)pos, totalPos, cout);
VectorOfParentalGenotypes* result=new VectorOfParentalGenotypes((int*)pos, totalPos);
ParentalGenotypesUsingPointers* pg;
Genotype* motherG, *fatherG;
for (Container<vector<Trio*>, Trio*>::iterator TrioPos=TrioList->getFirst(); TrioPos!=TrioList->end(); TrioPos++)
{
//if (getGenotype(TrioPos, mother)==NULL) cout <<"errr\n"; else cout <<*getGenotype(TrioPos, mother) <<"\n";
motherG=getGenotype(TrioPos, mother)->filter(pos,totalPos);
fatherG=getGenotype(TrioPos, father)->filter(pos,totalPos);
pg=new ParentalGenotypesUsingPointers(fatherG, motherG, TrioList->getPosition(TrioPos));
result->insertElement(pg);
}
return result;
}
catch (BasicException & be) {be.addMessage("\ncalled from TrioSample::getGenotypeCounts"); throw;};
}


/*____________________________________________________________ */
/*
int TrioSample::CountAlleles (SNPPos SNP, unsigned int Basis[5], IndCategory ic=parent, int gender, int affectation)
{
//bool Marked[phenotypeSample->size()];
setMarked(ic, gender, affectation);
return genotypeSample->CountAlleles(SNP, Basis, Marked);

}
*/
/*_________________________________________________________________________*/

intList* TrioSample::getPedigreeID(IndCategory ic)
{
intList* result=new intList();
Phenotype* phen;
Trio* T;
for (Container<vector<Trio*>, Trio*>::iterator it=TrioList->begin(); it!=TrioList->end(); it++)
{
T=TrioList->getElement(it);
for (int i=0; i<2;i++)
if (ic==(IndCategory)i || ic==everybody || (ic==parent && i<2))
{
phen=phenotypeSample->getElement(T->getPhenotype((IndCategory)i)); 
result->insertElement(phen->getPedigree());
}
}
return result;
}
/*____________________________________________________________ */

allele TrioSample::getMajorAllele (SNPPos SNP, IndCategory ic=parent, int gender, int affectation)
{
//cout <<GenomaSample::getGenotypeSample->MajorAllele(SNP, ic) <<"";

return GenomaSample::getMajorAllele(SNP, ic, gender, affectation);
}
/*____________________________________________________________ */

allele TrioSample::getMinorAllele (SNPPos SNP, IndCategory ic=parent, int gender, int affectation)
{
//cout <<GenomaSample::getMinorAllele(SNP, ic) <<"\n";
return GenomaSample::getMinorAllele(SNP, ic, gender, affectation);
}

/*____________________________________________________________ */
/*
TrioSample* TrioSample::copyElementsWithPositionsIn(intSet* positions, bool inThis)
{
GenomaSample* genomaResult=this->GenomaSample::copyElementsWithPositionsIn(positions, inThis);
TrioSample* result= new  TrioSample(*genomaResult, false);
zap(genomaResult);
return result;
}

/*____________________________________________________________ */

/*
TUCounts * TrioSample::getTUCounts(int *pos, int length, bool onlyHetero, int totalPermutations, AlleleOrderType alleleOrderType, PhaseAlg phaseAlg, EMDistributions emDistributions, EMRestriction emRestriction)
{
HapExtractionConfiguration* hapExtractionConfiguration=new HapExtractionConfiguration(alleleOrderType, phaseAlg, emDistributions, emRestriction);
return getTUCounts(pos, length, hapExtractionConfiguration, onlyHetero, totalPermutations);
}

/*____________________________________________________________ */


TUCounts* TrioSample::getTUCounts(int *pos, int length, HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations)
{
try
{

if (hapExtractionConfiguration->phaseAlg!=onlyKnown && length>10) throw OutOfBounds(10, length, "TUCounts* TrioSample::getTUCounts(int *pos,...");

    VectorOfParentalGenotypes* ts=getGenotypeCounts (pos, length);
    TUCounts* results= ts->getTUCounts (hapExtractionConfiguration, totalPermutations, pos, length);
    return results;















/*
if (hapExtractionConfiguration->phaseAlg!=onlyKnown) 
{
throw NonImplemented("TUCounts* TrioSample::getTUCounts(int *pos,...");
// code above should be used for partial genotypes and afterwards a unique tuCounts should be onbtained by ,erging all of them
cout <<"hhee\n";
TrioCounters* trioCounters=new TrioCounters(pos, length, this); // affectation is allAffectation, includeMissing is true
cout <<"bbb\n";
TrioCountersHapUAndT *tm= new TrioCountersHapUAndT(trioCounters, hapExtractionConfiguration->phaseAlg, hapExtractionConfiguration->emDistributions, hapExtractionConfiguration->emRestriction);
cout <<"jjjj\n";
if (tm->haplotypeCounts==NULL)
{
zap(tm);
zap(trioCounters);
return NULL;
}

HeteroPair<HaplotypeTUCountsVector*,ParentalHaplotypesUsingPointersList*>* h=tm->getTUCounts(onlyHetero);
HaplotypeTUCountsVector* haplotypeTUCountsVector=h->first();
ParentalHaplotypesUsingPointersList* parentalHaplotypesList=h->second();
h->First=NULL;
h->Second=NULL;
int ts=100;
if (totalPermutations>0) ts=totalPermutations;
TUCounts* tuCounts= new TUCounts (trioCounters, hapExtractionConfiguration, haplotypeTUCountsVector, parentalHaplotypesList, ts);
zap(tm);
zap(h);
return tuCounts;
}
else
*/
/*
VectorOfParentalGenotypes* parentalGenotypes=getGenotypeCounts (pos, length);
//cout << *parentalGenotypes <<"\n";
int* relativePositions=initializeFrom(0, length);
TUCounts* result=parentalGenotypes->getTUCounts(hapExtractionConfiguration, totalPermutations, relativePositions, length);
delete relativePositions;
//cout << *parentalGenotypes <<"\n";
//exit(0);
//cout <<"org is" << * result;
//cout <<"filt is" << * filt;
//delete parentalGenotypes;

return result;
*/
}
catch (BasicException & be) {be.addMessage("\ncalled from TUCounts* TrioSample::getTUCounts(int *pos, int length, HapExtractionConfiguration* hapExtractionConfiguration, bool onlyHetero, int totalPermutations)"); throw;};
}

/*______________________________________________________*/

void TrioSample::print(ostream& out)
       {
out << *TrioList <<"\n";
this->GenomaSample::print(out);
out <<"\n";
};

/*____________________________________________________________ */


};
// End of Namespace

#endif

/* End of file: TrioSample.h */




