/* File: VectorOfParentalGenotypesUsingPointers.h */

#ifndef __VectorOfParentalGenotypes_cpp__
#define __VectorOfParentalGenotypes_cpp__

//using namespace stats;

namespace BIOS {



VectorOfParentalGenotypes::VectorOfParentalGenotypes(int* absolutePositions, int length, int totalPermutations):ParentalGenotypesUsingPointersList(), GenericSample()
{
if (absolutePositions==NULL) throw NullValue("VectorOfParentalGenotypes::VectorOfParentalGenotypes(int* absolutePositions, int length, int totalPermutations):ParentalGenotypesUsingPointersList(), GenericSample()");
this->absolutePositions=absolutePositions;
this->length=length;
this->absolutePositions=new int[length];
for (int i=0; i<length;i++)
this->absolutePositions[i]=absolutePositions[i];
this->totalPermutations=totalPermutations;
this->permutations=NULL;
}
/*______________________________________________________*/

VectorOfParentalGenotypes::VectorOfParentalGenotypes(VectorOfParentalGenotypes& other): ParentalGenotypesUsingPointersList(other), GenericSample()
{
if (absolutePositions==NULL) throw NullValue("VectorOfParentalGenotypes::VectorOfParentalGenotypes(VectorOfParentalGenotypes& other): ParentalGenotypesUsingPointersList(other), GenericSample()");
this->length=other.length;
this->absolutePositions=new int[length];
for (int i=0; i<length;i++)
this->absolutePositions[i]=other.absolutePositions[i];
this->totalPermutations=0;
this->permutations=NULL;
};
/*______________________________________________________*/

VectorOfParentalGenotypes::~VectorOfParentalGenotypes()
{
zaparr(permutations, totalPermutations);
zaparr(absolutePositions);
};
/*______________________________________________________*/

VectorOfParentalGenotypes* VectorOfParentalGenotypes::clone()
{
return new VectorOfParentalGenotypes(*this);
};
/*______________________________________________________*/

TUCounts* VectorOfParentalGenotypes::getTUCounts(HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, int* relativePositions, int totalPos)
{
try
{
if (hapExtractionConfiguration->alleleOrderType!=LeftRight) throw NonImplemented("TUCounts* TrioSample::getTUCounts(int *pos, int length, HapExtractionConfiguration* hapExtractionConfiguration, bool onlyHetero, int totalPermutations). Phase has to be already solved");
VectorOfParentalHaplotypes* parentalHaplotypesList=this->getParentalHaplotypesList(relativePositions, totalPos);
//cout <<*parentalHaplotypesList;
HaplotypeTUCountsVector* haplotypeTUCountsVector=parentalHaplotypesList->getHaplotypeCountsVector();
TUCounts* result=new TUCounts(this, hapExtractionConfiguration, haplotypeTUCountsVector, parentalHaplotypesList, totalPermutations);
return result;
}
catch (BasicException& be){be.addMessage("\ncalled from TUCounts* VectorOfParentalGenotypes::getTUCounts(HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, int* relativePositions, int totalPos)"); throw;};
}

/*______________________________________________________*/

void VectorOfParentalGenotypes::setPermutations(int totalPermutations)
{
if (permutations!=NULL) 
{
if (totalPermutations!=this->totalPermutations)
throw BadFormat("VectorOfParentalGenotypes::setPermutations(int totalPermutations)");
return;
}
this->totalPermutations=totalPermutations;
permutations=new VectorOfParentalGenotypes*[totalPermutations];
for (int i=0; i<totalPermutations;i++)
{
//if (i%10==0) cout <<"setting permutation " << i << " in genotypes\n";
permutations[i]=getOnePermutation();
}
}
/*______________________________________________________*/

VectorOfParentalGenotypes* VectorOfParentalGenotypes::getOnePermutation(int* chosenPos, int chosenLength)
{
VectorOfParentalGenotypes* result;
if (chosenPos==NULL) result=new VectorOfParentalGenotypes(absolutePositions, length);
else result=new VectorOfParentalGenotypes(chosenPos, chosenLength);
ParentalGenotypesUsingPointers* pg, *pg2;
Genotype* father, *mother, *father2, *mother2;
int transmitted;
for (VectorOfParentalGenotypes::iterator it=begin(); it<end(); it++)
{
pg=getElement(it);
transmitted=ranbinom(1, 0.5);
if (chosenPos==NULL) father2=pg->father->clone(); else father2=pg->father->filter(chosenPos, chosenLength); 
if (!transmitted) father2->changePhase();
transmitted=ranbinom(1, 0.5);
if (chosenPos==NULL) mother2=pg->mother->clone(); else mother2=pg->mother->filter(chosenPos, chosenLength);
if (!transmitted) mother2->changePhase();
pg2=new ParentalGenotypesUsingPointers(father2, mother2, pg->trioCount);
result->insertElement(pg2);
}
return result;
}
/*______________________________________________________*/

void VectorOfParentalGenotypes::removePermutations()
{
zaparr(permutations, totalPermutations);
}
/*______________________________________________________*/

int* VectorOfParentalGenotypes::getPositions()
{
return absolutePositions;
}
/*______________________________________________________*/

int VectorOfParentalGenotypes::getTotalPositions()
{
return length;
}
/*______________________________________________________*/

int VectorOfParentalGenotypes::getTotalPermutations()
{
return totalPermutations;
}
/*______________________________________________________*/

VectorOfParentalGenotypes** VectorOfParentalGenotypes::getPermutations()
{
return permutations;
}
/*______________________________________________________*/

VectorOfParentalHaplotypes* VectorOfParentalGenotypes::getParentalHaplotypesList(int* relativePositions, int totalPos)
{
try
{
if (relativePositions==NULL) throw NullValue("VectorOfParentalHaplotypes* VectorOfParentalGenotypes::getParentalHaplotypesList(int* relativePositions, int totalPos)");
Haplotype *motherT, *fatherT, *motherU, *fatherU,  *motherTF, *fatherTF, *motherUF, *fatherUF;
ParentalGenotypesUsingPointers* element;
VectorOfParentalHaplotypes* result=new VectorOfParentalHaplotypes(relativePositions, totalPos);
//result->setPositions(relativePositions);
//result->setLength(totalPos);
for (VectorOfParentalGenotypes::iterator it=begin(); it<end();it++)
{
element=getElement(it);
motherT=element->mother->getLeftHaplotype();
motherU=element->mother->getRightHaplotype();
fatherT=element->father->getLeftHaplotype();
fatherU=element->father->getRightHaplotype();
motherTF=motherT->filter(relativePositions, totalPos);
motherUF=motherU->filter(relativePositions, totalPos);
fatherTF=fatherT->filter(relativePositions, totalPos);
fatherUF=fatherU->filter(relativePositions, totalPos);
result->insertElement(new ParentalHaplotypesUsingPointers(fatherTF, fatherUF, motherTF, motherUF, getPosition(it), (double)1, ' '));
zap(motherT); zap(motherU); zap(fatherT); zap(fatherU);
}
return result;
}
    catch (BasicException& be) {be.addMessage ("\ncalled from VectorOfParentalHaplotypes* VectorOfParentalGenotypes::getParentalHaplotypesList(int* relativePositions, int totalPos) "); throw;};
}
	
	/*______________________________________________________*/


 void VectorOfParentalGenotypes::print(ostream& out)
   {
   out <<"size is:" << length <<"\n";
for (int i=0; i<length;i++)
out <<"pos at " << i << ": " << absolutePositions[i] <<"\n";
   out << (ParentalGenotypesUsingPointersList&)*this;
   }
   
   	/*______________________________________________________*/

   
   ostream& operator<<(ostream& out, VectorOfParentalGenotypes& lista)
   {
   lista.print(out);
   return out;
   }
  
/*______________________________________________________*/


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




