/* File: ParentalGenotypesUsingPointers.h */

#ifndef __VectorOfParentalGenotypes_h__
#define __VectorOfParentalGenotypes_h__

//using namespace stats;

namespace BIOS {


/************************/
/* SNP'S MultimarkerMeasure DEFINITION */
/************************/


/**
        @memo __ParentalGenotypes 
	@doc
        Definition:

       Class used mainly to compute multimarker tdt or its many variants. In order to similarity measures to can be applied, haplotype counters (or freqs if EM-freq is used) for each couple must be independently kept. One trio may have more than one parentalHaplotype (freqs must sum 1). For this reason, attribute trioCount is required. 

       With this purpose, the class required is:
 

        @author Maria M. Abad Grau
	@version 1.0
*/

class VectorOfParentalHaplotypes;

	class VectorOfParentalGenotypes: public ParentalGenotypesUsingPointersList, public GenericSample
{
private:

//! Position of the alleles in the original sample
int* absolutePositions;
//! Length of the absolutePositions vector
int length;
int totalPermutations;
VectorOfParentalGenotypes** permutations;

public:
//VectorOfParentalGenotypes();
VectorOfParentalGenotypes(int* pos, int length, int permutations=0);
VectorOfParentalGenotypes(VectorOfParentalGenotypes& other);
VectorOfParentalHaplotypes* getParentalHaplotypesList(int* relativePositions, int totalPos);
//ParentalGenotypes(TrioSample* trioSample, int* pos, int length);
virtual ~VectorOfParentalGenotypes();
TUCounts* getTUCounts(HapExtractionConfiguration* hapExtractionConfiguration, int totalPermutations, int* relativePositions, int totalPos);
//TUCounts* getPermutationTUCounts(hapExtractionConfiguration);
void setPermutations(int totalPermutations);
VectorOfParentalGenotypes** getPermutations();
//VectorOfParentalGenotypes* filter(int* relativePositions, int size);
int* getPositions();
int getTotalPositions();
int getTotalPermutations();
virtual VectorOfParentalGenotypes* clone();
void removePermutations();
VectorOfParentalGenotypes* getOnePermutation(int* pos=NULL, int length=0);
//TUCounts * getPermutationTUCounts (HapExtractionConfiguration* hapExtractionConfiguration);
void print(ostream& out);
friend ostream& operator<<(ostream& out, VectorOfParentalGenotypes& lista);
};
	



  


};  // End of Namespace

#endif

/* End of file: MultimarkerMeasure.h */




