/* File: VirtualPositions.h */

#ifndef __VirtualPositions_h__
#define __VirtualPositions_h__


namespace BIOS
{


  /************************/
  /* VirtualPositions DEFINITION */
  /************************/


  /**
          @memo VirtualPositions for SNPs
   
  	@doc
          Definition:
          A set of phenotype's features and genotypes for an VirtualPositions
   
          Memory space: O(TotalSNPs), which TotalSNPs being the number of SNPs in the sample
          Each VirtualPositions in a sample has been genotyped for the same TotalSNPs SNPs.
   
          @author Maria M. Abad
  	@version 1.0
  */

   struct PosS
  {
    double pos;
    SNPPos filepos;
    string rsNumber;
    bool  operator>(const struct PosS & po){return pos>po.pos;}
    ;;
    bool  operator<(const struct PosS & po){return pos<po.pos;}
    ;;
    string print(){char l[20]; l[0]='\0'; sprintf (l, "(%f -- %d)\n", pos, filepos); return string(l);};
    PosS(){};
    PosS(PosS& source){pos=source.pos; filepos=source.filepos; rsNumber=source.rsNumber;};
    ~PosS(){};
    PosS* clone()
    {
     return new PosS(*this);
    }

    static PosS* fromString(string s)
{
struct PosS* p=new PosS();
p->pos=atof(s.c_str());
return p;
};
  };

/*______________________________________________________*/

ostream& operator<<(ostream& out, PosS posS)
{
   // out << "\n";
out << posS.print();
return out;
  }

/*______________________________________________________*/


  class VirtualPositions: public Container<vector<PosS*>, PosS*>
  {

  private:
    /** @name Implementation of class VirtualPositions
        @memo Private part.
    */

    void SetFilePos ();

    /***************************************************************/
    /***     ASSOCIATED FUNCTIONS     ***/
    /*********************************************************************/

    /* Head */





  protected:

  //  PosS* VirtualPositions::readElement (ifstream * source, char* tokens);//{cout <<"p";}


    //	  PosS VirtualPositions::GetExtremeElement(bool max){cout <<"Not implemented yet";exit(0);};


    char filename[256], fileRS[256];

    /* PUBLIC FUNCTIONS (INTERFACE) */




  public:


    /**
            @memo Constructor 
            @doc
             Allocate memory an initialize to null.
             Complexity O(1).

         */

    VirtualPositions(char* filename);

    VirtualPositions():Container<vector<PosS*>, PosS*>(){};

    //VirtualPositions(PosS& source):ListOfPointers<PosS>(source){};


    ~VirtualPositions(){};

    /**
          @memo Creates a new VirtualPositions object with the phase resolved.
          @param Origen: the origianl VirtualPositions object 
          Time complexity O(TotalSNPs*Size*Size)

       */
    void addRSNumbers();

    string getRSNumber(SNPPos SNP);

    string getRSNumber(VirtualPositions::iterator p);

    void PrintPositions(char* filename);

    void PrintRSNumbers(char* filename);


    SNPPos GetTotalSNPs();

    void CheckRangeSNP(SNPPos SNP);

    double getPosition(SNPPos SNP);
    
     double getPosition(VirtualPositions::iterator p);


    void CheckFilename(char* filename){};

    void PrintVirtualPositions (char* filename);

    string PrintPosition(SNPPos SNP, int integerPart=0, int decimalPart=0);
    string PrintPosition(VirtualPositions::iterator p, int integerPart=0, int decimalPart=0);

    
    Container<vector<SNPPos>, SNPPos>* GetOnlyFilePos ();

    void SNPSampling (Container<vector<SNPPos>, SNPPos> *Sampling);

    void ChangeUnits (SNPPos factor);

    PosS* GetExtremeElement(bool max);

    bool  operator=(const VirtualPositions & vp){cout <<" VirtualPositions::operator= not implemented yet"; exit(0);}
    ;;



    //	virtual void CheckFilename(char* filename);


  }
  ;  // End of class VirtualPositions

/*______________________________________________________*/

     ostream& operator<<(ostream& out, VirtualPositions& l)
{
//if (l.size()>1) out <<"(";
struct PosS *s;
VirtualPositions::iterator p=l.getFirst();
cout <<"\n";
while (p!=l.end())
    {
s= *p; 
cout << *s; 
p=l.getNext(p); 
      if (l.size()>1)  if (p!=l.end()) out <<","; //else out <<")";

}
return out;
}

}
;  // Fin del Namespace

#endif

/* Fin Fichero: VirtualPositions.h */
