



#include "../FachadeGenoma.cpp"


/*______________________________________________________________________________*/


using namespace BIOS;

/*_______________________________________________________________________________*/

int main ( int argc, char*argv[] )
{

srand(100);
try
{
	if ( argc<3 )
	{
		cerr << "Error: you have to especify the following information:" << endl;
		cerr  << argv[0] << " <input filename> "
		<< " <totalSamples>" << "<allele order type: 2 (LeftRight, default), 3: LeftRightUsingTrios>" << "<EM distributions: 0: one distribution, 1: UT distributions (default)>" << "<EM restrictions: 0: no restrictions, 1: triosBased restriction (default)>" << "<phaseMethod: 0 ignore unknown, 1 EM-Max, 2 EM-Freq (default) > " << "<ini pos (default: 0)> <total length (default: -1, till the end)>"<< "<window width (default: 10)> <window offset (default: 1)>" << "<only hetero (1 (true, default), 0 (false)>";
		exit ( -1 );
	}
	bool onlyHetero=true;
	char filename[256], wholefilename[256]="\0";
	strcpy (filename, argv[1]);
	int totalSamples=atoi (argv[2]);
//totalSamples=1;

char resultsDir[256]="\0";



double minFreq=0;
	int prop=1;
AlleleOrderType alleleOrderType=LeftRight;
 PhaseAlg phaseAlg=weighted;
 
 bool testModeForInsideMeasure=true;
 
 

 
EMDistributions emDistributions=UTDistributions;
EMRestriction emRestriction=triosBasedRestriction;
if (argc>=4) alleleOrderType=(AlleleOrderType)atoi(argv[3]);


if (alleleOrderType!=LeftRight && alleleOrderType!=LeftRightUsingTrios) throw BadFormat(string("main, alleleOrderType\n"));

if (argc>=5)  emDistributions=(EMDistributions)atoi(argv[4]);
if (argc>=6)  emRestriction=(EMRestriction)atoi(argv[5]);
if (argc>=7)  phaseAlg=(PhaseAlg)atoi(argv[6]);


if (phaseAlg!=maxFreq && phaseAlg!=weighted && phaseAlg!=onlyKnown) throw BadFormat(string("main, phase alg\n"));
if (emDistributions!=UTDistributions && emDistributions!=oneDistribution) throw BadFormat(string("main, EM distributions\n"));
if (emRestriction!=noRestriction && emRestriction!=triosBasedRestriction) throw BadFormat(string("main, EM restriction\n"));

//cout <<"\nconf: allele order type: " << alleleOrderType <<", EM distributions: " << emDistributions <<", EM restriction: " << emRestriction << ", phase alg: " << phaseAlg <<"\n";

int totalPermutations=0, width=10, offset=1;

bool maxHap=true;

int numberOfFolds=5;
int iniPos=0;
int length=-1;
	if (argc>=8)  iniPos=atoi (argv[7]);
	if (argc>=9)  length=atoi (argv[8]);

	if (argc>=10)
	{
	width=atoi (argv[9]);
	}
		if (argc>=11)
		{
	offset=atoi(argv[10]);
	}
if (argc>=12)
onlyHetero=atoi(argv[11]);



bool verticalOutput=true;


bool returnPVals=false;


ListOfGenericMeasures *tuMeasures=new ListOfGenericMeasures();



//if (testMode==tTraining || testMode==tHalfTraining) testModeGroupMeasures=1; //  Bonferroni correction is used (low power because it is an overcorrection)
//else 
int testModeGroupMeasures=0; // usual testing (low specificity because of ad-hoc grouping)



//{ut=0, t=1, u=2}





tuMeasures->insertElement(new TDT1Measure(0, 0.0, testModeGroupMeasures, numberOfFolds)); 


//tuMeasures->insertElement(new TDTMeasure(10, false));
tuMeasures->insertElement(new TDTPMeasure(0, false, false));



//if (testModeForInsideMeasure) testMode=tTraining;

bool measureFiles=1;
TestMode testMode=(TestMode)3;


GWAS* gwas=new GWAS(tuMeasures, filename, resultsDir, totalSamples, testMode, numberOfFolds, testModeForInsideMeasure, width, offset, totalPermutations, iniPos, length, measureFiles, onlyHetero, returnPVals);


gwas->printResultsForWindows(verticalOutput, false);
gwas->printAverageResults(verticalOutput);



zap(gwas);



return 0;
} // end try
catch (NonProb np){np.PrintMessage();}
catch (NoMemory nm){}
catch (BIOS::OutOfRange<int>::OutOfRange<int> rr){rr.PrintMessage();}
catch (BIOS::OutOfRange<long long int>::OutOfRange<long long int> rl){rl.PrintMessage();}
catch (NullValue nv){nv.PrintMessage();}
catch (NonInteger nv){nv.PrintMessage();}
catch (Inconsistent in){in.PrintMessage();}
catch (BadFormat bf){bf.PrintMessage();}
catch (NonSNP ns){ns.PrintMessage();}
catch (NonDefined nf){nf.PrintMessage();}
catch (OverflowedSNP os){os.PrintMessage();}
catch (OutOfBounds ob){ob.PrintMessage();}
catch (NonImplemented ni){ni.PrintMessage();}
catch (bad_alloc ba){ba.what();cout <<"bad alloc\n"; exit(0);}
catch (ZeroValue zv){zv.PrintMessage();}
catch (NoWindow nw) {nw.PrintMessage();}
catch (EmptyFile ef) {ef.PrintMessage();}
catch (AlreadyOpen ao) {ao.PrintMessage();}
catch (ErrorFile & eef) {eef.PrintMessage();}
catch (NoEOL & ne) {ne.PrintMessage();}
catch (AlreadyExist & aee) {aee.PrintMessage();}
catch (NanValue & nv) {nv.PrintMessage();}
catch (BasicException & be){be.PrintMessage();};
;
	return 1;
}



