

#ifndef __simulationTDT__
#define __simulationTDT__

#include "../commonc++/Fachade.h"
//#include "../../../FachadeGenoma.h"






namespace BIOS
{
class SimulationTDT
{
public:


SimulationTDT(int totalSamples, int sampleSize, int totalInds, double mutationRate, double mafDPOP1, double mafDPOP2, double mafEPOP1, double mafEPOP2, double pp, double recProbWithinBlock, double recProbBetweenDiseaseLoci, int diseaseLocus1, int diseaseLocus2, int iniUnlinkedLocus, int totalSNPs, int relativeRisk, int genotypeModel, int test, char* filename, double margin);
        
	void printSample ( BidimensionalTable<bool>* childSample,BidimensionalTable<bool>* fatherSample,BidimensionalTable<bool>* motherSample, string filename, int diseaseLocus1, int diseaseLocus2, int totalSNPs, int sampleSize );

	void getSampleFromStratPop ( BidimensionalTable<bool>* POP, BidimensionalTable<bool>*& sample,BidimensionalTable<bool>*& fatherSample,BidimensionalTable<bool>*& motherSample,int sampleSize, int totalSNPs, int diseaseLocus1, int diseaseLocus2, double mafDPOP,  double recProb, int iniUnlinkedLocus, double pAffDD, double pAffDd, double pAffdd);

void joinSamples ( BidimensionalTable<bool>*& childSample,BidimensionalTable<bool>*& fatherSample,BidimensionalTable<bool>*& motherSample, BidimensionalTable<bool>*& childSample2,BidimensionalTable<bool>*& fatherSample2,BidimensionalTable<bool>*& motherSample2);
	/*___________________________________________________________________*/
	
	BidimensionalTable<double>* setGenotypeParentsFreqs (double * freqs);

	intSample* getHaps (BidimensionalTable<bool>* POP, int firstLocus, int secondLocus, int diseaseLocus1, int diseaseLocus2);

	BidimensionalTable<double>* getFreqs(double mafD, double mafE, int genotypeModel, int RR, int test, double recProbs);


	BidimensionalTable<double>* setTransmittedHaplotypeParentsFreqsGivenAffectedChild ( int model, int RR, int test, double pde, double pdE, double pDe, double pDE );

	double* setHaplotypeFreqs ( double pde, double pdE, double pDe, double pDE, int test);

	/*___________________________________________________________________*/
	
double* setGenotypeFreqs (double pdDeE, double pddee,double pDDEE,double pDDee,double pddEE,double pddeE,double pDDeE,double pdDEE,double pdDee );
	
BidimensionalTable<double>* setGenotypeParentsFreqsGivenAffectedChild (int model, int RR, int test, double pdDeE, double pddee,double pDDEE,double pDDee,double pddEE,double pddeE,double pDDeE,double pdDEE,double pdDee );
        
BidimensionalTable<double>* setConditionalChildGenotypeFreqs (BidimensionalTable<double>* parentGens );
        
	int getAllele(int genotype1, int genotype2, int locus, int haplotypePos);

	int getTotalPairs ( int genotypeLocus1, int genotypeLocus2 );
	/*___________________________________________________________________*/
	
	double* setGenotypeRisksSingleModel (int model, int RR);
	/*___________________________________________________________________*/

	double* setGenotypeRisks ( int model, int RR);
	/*___________________________________________________________________*/

	void setGenotypeFreqs ( double* pGen, int model, int RR, double pdDeE, double pddee,double pDDEE,double pDDee,double pddEE,double pddeE,double pDDeE,double pdDEE,double pdDee );

  bool sameSNPs(intList* row1, intList* row2, int diseaseLocus1, int diseaseLocus2);
	/*___________________________________________________________________*/

	void setParentTransmittedAlleles ( int &fatherTransmittedDiseaseLocus1, int &fatherTransmittedDiseaseLocus2, int& motherTransmittedDiseaseLocus1, int &motherTransmittedDiseaseLocus2, int &childGenotype, int recomb );
	/*___________________________________________________________________*/

	bool isAffected ( int totalMajor1, int totalMajor2, double *risk );
/*___________________________________________________________________*/

	bool isHetero ( BidimensionalTable<bool>* POP, int pos);
	/*___________________________________________________________________*/

	void getSampleFromPop ( BidimensionalTable<bool>* POP,BidimensionalTable<bool>*& sample,BidimensionalTable<bool>*& fatherSample,BidimensionalTable<bool>*& motherSample, int sampleSize, int test, int RR, int genotypeModel, int totalSNPs, double recProb, int diseaseLocus1, int diseaseLocus2, double mafDPOP, double mafEPOP);

	/*___________________________________________________________________*/

 intList* findDifferentUHap(intSample* haps, int& count, int*countPos, intList*rowT, int diseaseLocus1, int diseaseLocus2);

 /*___________________________________________________________________*/

  bool findDifferentUTHaps(intSample* hapsT, int& countT, int*countPosT,
intSample* hapsU, int& countU, int*countPosU, intList*&rowT, intList*& rowU, int diseaseLocus1, int diseaseLocus2);

	/*___________________________________________________________________*/
	
bool setSampleHaplotype(BidimensionalTable<bool>* parentSample, BidimensionalTable<bool>* childSample, int parentLocus1, int parentLocus2, int test, intSample* deHaps, intSample* dEHaps, intSample* DeHaps, intSample* DEHaps, int& deP, int& dEP, int&DeP, int& DEP, int &cont, int*dePos, int* dEPos, int* DePos, int* DEPos);
	/*___________________________________________________________________*/

  bool setSampleUntransmittedHaplotype (BidimensionalTable<bool>* parentSample, intSample* originalHaps, int &oP, int &cont,  int*originalPos);


	/*_____________________________________________________________________________*/

	void setInitialPop ( int totalInds, int totalSNPs, int diseaseLocus1, int diseaseLocus2, int test, BidimensionalTable<bool>*& POP, double mafOrig );

	/*_____________________________________________________________________________*/

	bool firstTest ( BidimensionalTable<bool>*& POP, int gene, int diseaseLocus1, int diseaseLocus2, double &freqMut1, double &freqMut2, double mafOrig, double margin, int totalGenerations, double mafD, double mafE, int test );
	/*_____________________________________________________________________________*/

	bool testTotalInds ( BidimensionalTable<bool>*& POP, int newTotalInds, int* father, int*mother, int* numberOfChildren );
	/*_____________________________________________________________________________*/

	int getNumberOfChildren ( int gene, int totalInds, int fatherT, int fatherU, int motherT, int motherU, int chosenAffected, int totalGenerations,  BidimensionalTable<bool>*& POP, int diseaseLocus1, int diseaseLocus2, int test, double mafD, double mafE);
	
	/*_____________________________________________________________________________*/

	void chooseParents ( int totalInds,  int*& father, int*& mother );

	/*_____________________________________________________________________________*/

double getAlleleFreq ( BidimensionalTable<bool>* POP, int position );
	
	/*_____________________________________________________________________________*/
/*
	int getNumberOfChildren ( double growthRate, int gene, int fatherT, int fatherU, int motherT, int motherU, int chosenAffected, int totalGenerations,   BidimensionalTable<bool>*& POP, int diseaseLocus1, int diseaseLocus2, int test, double mafD, double mafE, double margin  );

	/*_____________________________________________________________________________*/

//	int getNewTotalInds ( int gene, int numberOfChildren, int totalGenerations );
	
	/*_____________________________________________________________________________*/

	int* getNumberOfChildrenArray ( int totalInds, int gene,int*  father, int* mother, int chosenAffected, int totalGenerations, int &newTotalInds,  BidimensionalTable<bool>*& POP, int diseaseLocus1, int diseaseLocus2, int test, double mafD, double mafE);

	/*_____________________________________________________________________________*/

	void chooseTransmittedHaplotypes ( int& motherT, int& motherU, int& fatherT, int& fatherU, int mother, int father );



	/*_____________________________________________________________________________*/

	void setValueForBlock ( int parentT, int parentU, double recProb2, double recProb, int iniUnlinkedLocus, BidimensionalTable<bool>* POP, BidimensionalTable<bool>* childrenPOP, int position, int totalSNPs );

	/*_____________________________________________________________________________*/

	void setChildrenHaplotypes ( int parentT, int parentU, BidimensionalTable<bool>* POP, BidimensionalTable<bool>* childrenPOP, double recProb, double recProb2, int position, int iniUnlinkedLocus, int totalSNPs, int gene, int totalGenerations, double mutationRate, int diseaseLocus1, int diseaseLocus2);

	/*_____________________________________________________________________________*/
/*
	void setParentsHaplotypes ( int fatherT, int fatherU, int motherT, int motherU, int cont, BidimensionalTable<bool>* POP, BidimensionalTable<bool>* fatherPOP, BidimensionalTable<bool>* motherPOP, int totalSNPs );
	
	/*_____________________________________________________________________________*/

	void setHaplotypes ( int totalInds, int* numberOfChildren, int totalGenerations, int gene, int iniUnlinkedLocus, BidimensionalTable<bool>* POP, BidimensionalTable<bool>* childrenPOP, double recProb, double recProb2, int* father, int* mother, double mutationRate, int diseaseLocus1, int diseaseLocus2, int totalSNPs);
	

	/*_____________________________________________________________________________*/

	void setPop ( int totalGenerations, int totalSNPs, int totalInds, int test, double mafD, double mafE, BidimensionalTable<bool>*& POP,  double &freqMut1, double &freqMut2, int diseaseLocus1, int diseaseLocus2, int iniUnlinkedLocus, double recProb, double recProb2, double mutationRate, double margin );


};// end class

}; // end namespace bios

#endif



