/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import org.jdesktop.beansbinding.BindingGroup;

public class Classifier
extends JFrame {
    int acs;
    int ageCat;
    int bTransf;
    int bil;
    int ldhCat;
    int mcv;
    int pain;
    int priapism;
    int retic;
    int sepsis;
    int sex;
    int stroke;
    int sysBpCat;
    int wbcCat;
    int hemo;
    int avn;
    int acs2;
    int ageCat2;
    int bTransf2;
    int bil2;
    int ldhCat2;
    int mcv2;
    int pain2;
    int priapism2;
    int retic2;
    int sepsis2;
    int sex2;
    int stroke2;
    int sysBpCat2;
    int wbcCat2;
    int hemo2;
    int avn2;
    double[][] acsP = new double[][]{{0.564, 0.476}, {0.348, 0.652}, {0.26, 0.74}};
    double[][] wbcCatP = new double[][]{{0.488, 0.294, 0.218}, {0.373, 0.308, 0.318}};
    double[][] priapismP = new double[][]{{0.476, 0.044, 0.48}, {0.349, 0.112, 0.539}, {0.296, 0.093, 0.611}};
    double[][] bilP = new double[][]{{0.535, 0.348, 0.117}, {0.163, 0.603, 0.234}, {0.052, 0.513, 0.435}};
    double[][][] bTransfP = new double[][][]{new double[][]{{0.953, 0.047}, {0.904, 0.096}, {0.82, 0.18}}, new double[][]{{0.85, 0.15}, {0.823, 0.177}, {0.714, 0.286}}};
    double[][][] reticP = new double[][][]{new double[][]{{0.445, 0.439, 0.117}, {0.111, 0.573, 0.316}, {0.071, 0.52, 0.409}}, new double[][]{{0.247, 0.552, 0.201}, {0.088, 0.501, 0.411}, {0.042, 0.441, 0.517}}};
    double[][][] ldhCatP = new double[][][]{new double[][]{{0.511, 0.427, 0.062}, {0.382, 0.519, 0.099}, {0.224, 0.582, 0.194}}, new double[][]{{0.319, 0.57, 0.111}, {0.174, 0.582, 0.244}, {0.08, 0.49, 0.43}}, new double[][]{{0.379, 0.448, 0.173}, {0.183, 0.584, 0.233}, {0.148, 0.471, 0.381}}};
    double[][][] sexP = new double[][][]{new double[][]{{0.001, 0.999}, {0.006, 0.994}, {0.999, 0.001}}, new double[][]{{0.013, 0.987}, {0.034, 0.966}, {0.991, 0.009}}};
    double[][][][] ageCatP = new double[][][][]{new double[][][]{new double[][]{{0.451, 0.388, 0.161}, {0.242, 0.288, 0.47}}, new double[][]{{0.414, 0.447, 0.139}, {0.278, 0.511, 0.211}}, new double[][]{{0.484, 0.445, 0.072}, {0.333, 0.333, 0.333}}}, new double[][][]{new double[][]{{0.721, 0.196, 0.083}, {0.317, 0.417, 0.266}}, new double[][]{{0.492, 0.41, 0.099}, {0.222, 0.498, 0.28}}, new double[][]{{0.415, 0.51, 0.075}, {0.209, 0.525, 0.266}}}, new double[][][]{new double[][]{{0.908, 0.054, 0.038}, {0.22, 0.73, 0.05}}, new double[][]{{0.675, 0.3, 0.025}, {0.207, 0.408, 0.385}}, new double[][]{{0.487, 0.453, 0.06}, {0.183, 0.409, 0.409}}}};
    double[][][][] painP = new double[][][][]{new double[][][]{new double[][]{{0.507, 0.493}, {0.128, 0.872}, {0.18, 0.82}}, new double[][]{{0.191, 0.809}, {0.072, 0.928}, {0.052, 0.948}}}, new double[][][]{new double[][]{{0.135, 0.865}, {0.074, 0.926}, {0.104, 0.896}}, new double[][]{{0.071, 0.929}, {0.033, 0.967}, {0.038, 0.962}}}};
    double[][][][] sepsisP = new double[][][][]{new double[][][]{new double[][]{{0.956, 0.044}, {0.154, 0.846}}, new double[][]{{0.885, 0.115}, {0.128, 0.872}}}, new double[][][]{new double[][]{{0.983, 0.017}, {0.189, 0.811}}, new double[][]{{0.946, 0.054}, {0.12, 0.88}}}, new double[][][]{new double[][]{{0.968, 0.032}, {0.2, 0.8}}, new double[][]{{0.942, 0.058}, {0.273, 0.727}}}};
    double[][][][] strokeP = new double[][][][]{new double[][][]{new double[][]{{0.993, 0.007}, {0.8, 0.2}}, new double[][]{{0.954, 0.046}, {0.8, 0.2}}}, new double[][][]{new double[][]{{0.971, 0.029}, {0.702, 0.298}}, new double[][]{{0.844, 0.156}, {0.788, 0.212}}}, new double[][][]{new double[][]{{0.949, 0.051}, {0.863, 0.137}}, new double[][]{{0.777, 0.223}, {0.622, 0.378}}}};
    double[][][][] sysBpCatP = new double[][][][]{new double[][][]{new double[][]{{0.019, 0.862, 0.118, 0.001}, {0.004, 0.988, 0.004, 0.004}, {0.016, 0.86, 0.062, 0.062}}, new double[][]{{0.008, 0.967, 0.022, 0.003}, {0.0, 0.998, 0.002, 0.0}, {0.001, 0.954, 0.036, 0.009}}}, new double[][][]{new double[][]{{0.07, 0.61, 0.31, 0.01}, {0.036, 0.892, 0.036, 0.036}, {0.045, 0.592, 0.318, 0.045}}, new double[][]{{0.04, 0.79, 0.13, 0.04}, {0.003, 0.967, 0.027, 0.003}, {0.004, 0.857, 0.099, 0.04}}}};
    double[][][][] hemoP = new double[][][][]{new double[][][]{new double[][]{{0.872, 0.079, 0.049}, {0.475, 0.266, 0.259}, {0.139, 0.489, 0.372}}, new double[][]{{0.769, 0.128, 0.103}, {0.162, 0.566, 0.272}, {0.012, 0.765, 0.223}}, new double[][]{{0.522, 0.365, 0.113}, {0.051, 0.767, 0.182}, {0.002, 0.841, 0.157}}}, new double[][][]{new double[][]{{0.79, 0.105, 0.105}, {0.136, 0.491, 0.373}, {0.011, 0.864, 0.125}}, new double[][]{{0.446, 0.316, 0.238}, {0.039, 0.696, 0.265}, {0.001, 0.786, 0.213}}, new double[][]{{0.35, 0.301, 0.35}, {0.001, 0.791, 0.208}, {0.001, 0.925, 0.074}}}, new double[][][]{new double[][]{{0.58, 0.352, 0.068}, {0.097, 0.633, 0.27}, {0.011, 0.807, 0.162}}, new double[][]{{0.409, 0.466, 0.125}, {0.009, 0.762, 0.229}, {0.001, 0.887, 0.112}}, new double[][]{{0.253, 0.675, 0.072}, {0.013, 0.814, 0.173}, {0.002, 0.91, 0.088}}}};
    double[][][][] mcvP = new double[][][][]{new double[][][]{new double[][]{{0.684, 0.315, 0.001}, {0.25, 0.739, 0.011}, {0.569, 0.427, 0.004}}, new double[][]{{0.268, 0.726, 0.006}, {0.194, 0.658, 0.148}, {0.472, 0.519, 0.009}}, new double[][]{{0.289, 0.685, 0.026}, {0.023, 0.838, 0.139}, {0.03, 0.637, 0.333}}}, new double[][][]{new double[][]{{0.353, 0.645, 0.002}, {0.125, 0.856, 0.019}, {0.407, 0.592, 0.001}}, new double[][]{{0.118, 0.85, 0.032}, {0.052, 0.733, 0.215}, {0.189, 0.793, 0.018}}, new double[][]{{0.142, 0.716, 0.142}, {0.028, 0.624, 0.348}, {0.104, 0.842, 0.054}}}, new double[][][]{new double[][]{{0.752, 0.124, 0.124}, {0.062, 0.878, 0.06}, {0.227, 0.754, 0.019}}, new double[][]{{0.124, 0.752, 0.124}, {0.017, 0.621, 0.362}, {0.067, 0.866, 0.067}}, new double[][]{{0.333, 0.333, 0.333}, {0.017, 0.491, 0.491}, {0.019, 0.868, 0.113}}}};
    double[][][][] avnP = new double[][][][]{new double[][][]{new double[][]{{0.939, 0.061}, {0.768, 0.232}, {0.668, 0.332}}, new double[][]{{0.821, 0.179}, {0.723, 0.277}, {0.75, 0.25}}, new double[][]{{0.584, 0.416}, {0.705, 0.295}, {0.769, 0.231}}}, new double[][][]{new double[][]{{0.9, 0.1}, {0.679, 0.321}, {0.518, 0.482}}, new double[][]{{0.765, 0.235}, {0.565, 0.435}, {0.537, 0.463}}, new double[][]{{0.447, 0.553}, {0.565, 0.435}, {0.599, 0.401}}}};
    private JLabel ACS_label;
    private JLabel AVN_label;
    private JComboBox Acs;
    private JComboBox AgeCat;
    private JComboBox Avn;
    private JComboBox BTransf;
    private JComboBox Bil;
    private JComboBox Hemo;
    private JLabel LDH_label;
    private JComboBox LdhCat;
    private JLabel MCV_label;
    private JComboBox Mcv;
    private JComboBox Pain;
    private JComboBox Priapism;
    private JComboBox Retic;
    private JComboBox Sepsis;
    private JComboBox Sex;
    private JComboBox Stroke;
    private JComboBox SysBpCat;
    private JLabel WBC_label;
    private JComboBox WbcCat;
    private JLabel age_label;
    private JLabel bilirubin_label;
    private JLabel bloodTransfusion_label;
    private JButton estimateRisk_button;
    private JLabel gender_label;
    private JLabel hemoglobinGenotype_label;
    private JOptionPane jOptionPane1;
    private JLabel pain_label;
    private JPanel panelCentral;
    private JPanel panelNorte;
    private JPanel panelSur;
    private JLabel priapism_label;
    private JLabel progress;
    private JLabel resultLabel;
    private JLabel retic_label;
    private JLabel sepsis_label;
    private JLabel stroke_label;
    private JLabel systolicBP_label;
    private JLabel titulo;
    private BindingGroup bindingGroup;

    public static void main(String[] args) {
        Classifier classi = new Classifier();
        try {
            classi.initComponents();
            classi.dispatchEvent(new WindowEvent(classi, 201));
            classi.setPreferredSize(new Dimension(700, 550));
            classi.bindingGroup.unbind();
            classi.pack();
            classi.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private double computeRisk(int death) {
        double risk = 0.0;
        int acsMax = this.Acs.getItemCount() - 2;
        int ageCatMax = this.AgeCat.getItemCount() - 2;
        int bTransfMax = this.BTransf.getItemCount() - 2;
        int bilMax = this.Bil.getItemCount() - 2;
        int ldhCatMax = this.LdhCat.getItemCount() - 2;
        int mcvMax = this.Mcv.getItemCount() - 2;
        int painMax = this.Pain.getItemCount() - 2;
        int priapismMax = this.Priapism.getItemCount() - 2;
        int reticMax = this.Retic.getItemCount() - 2;
        int sepsisMax = this.Sepsis.getItemCount() - 2;
        int sexMax = this.Sex.getItemCount() - 1;
        int strokeMax = this.Stroke.getItemCount() - 2;
        int sysBpCatMax = this.SysBpCat.getItemCount() - 2;
        int wbcCatMax = this.WbcCat.getItemCount() - 2;
        int hemoMax = this.Hemo.getItemCount() - 2;
        int avnMax = this.Avn.getItemCount() - 2;
        int acsMin = 0;
        int ageCatMin = 0;
        int bTransfMin = 0;
        int bilMin = 0;
        int ldhCatMin = 0;
        int mcvMin = 0;
        int painMin = 0;
        int priapismMin = 0;
        int reticMin = 0;
        int sepsisMin = 0;
        int sexMin = 0;
        int strokeMin = 0;
        int sysBpCatMin = 0;
        int wbcCatMin = 0;
        int hemoMin = 0;
        int avnMin = 0;
        if (this.wbcCat != this.WbcCat.getItemCount() - 1) {
            wbcCatMax = this.wbcCat;
            wbcCatMin = this.wbcCat;
        }
        if (this.retic != this.Retic.getItemCount() - 1) {
            reticMax = this.retic;
            reticMin = this.retic;
        }
        if (this.ageCat != this.AgeCat.getItemCount() - 1) {
            ageCatMax = this.ageCat;
            ageCatMin = this.ageCat;
        }
        sexMax = this.sex;
        sexMin = this.sex;
        if (this.sepsis != this.Sepsis.getItemCount() - 1) {
            sepsisMax = this.sepsis;
            sepsisMin = this.sepsis;
        }
        if (this.stroke != this.Stroke.getItemCount() - 1) {
            strokeMax = this.stroke;
            strokeMin = this.stroke;
        }
        if (this.sysBpCat != this.SysBpCat.getItemCount() - 1) {
            sysBpCatMax = this.sysBpCat;
            sysBpCatMin = this.sysBpCat;
        }
        if (this.bil != this.Bil.getItemCount() - 1) {
            bilMax = this.bil;
            bilMin = this.bil;
        }
        if (this.ldhCat != this.LdhCat.getItemCount() - 1) {
            ldhCatMax = this.ldhCat;
            ldhCatMin = this.ldhCat;
        }
        if (this.priapism != this.Priapism.getItemCount() - 1) {
            priapismMax = this.priapism;
            priapismMin = this.priapism;
        }
        if (this.pain != this.Pain.getItemCount() - 1) {
            painMax = this.pain;
            painMin = this.pain;
        }
        if (this.acs != this.Acs.getItemCount() - 1) {
            acsMax = this.acs;
            acsMin = this.acs;
        }
        if (this.mcv != this.Mcv.getItemCount() - 1) {
            mcvMax = this.mcv;
            mcvMin = this.mcv;
        }
        if (this.bTransf != this.BTransf.getItemCount() - 1) {
            bTransfMax = this.bTransf;
            bTransfMin = this.bTransf;
        }
        if (this.hemo != this.Hemo.getItemCount() - 1) {
            hemoMax = this.hemo;
            hemoMin = this.hemo;
        }
        if (this.avn != this.Avn.getItemCount() - 1) {
            avnMax = this.avn;
            avnMin = this.avn;
        }
        this.wbcCat2 = wbcCatMin;
        while (this.wbcCat2 <= wbcCatMax) {
            this.retic2 = reticMin;
            while (this.retic2 <= reticMax) {
                this.ageCat2 = ageCatMin;
                while (this.ageCat2 <= ageCatMax) {
                    this.sex2 = sexMin;
                    while (this.sex2 <= sexMax) {
                        this.sepsis2 = sepsisMin;
                        while (this.sepsis2 <= sepsisMax) {
                            this.stroke2 = strokeMin;
                            while (this.stroke2 <= strokeMax) {
                                this.sysBpCat2 = sysBpCatMin;
                                while (this.sysBpCat2 <= sysBpCatMax) {
                                    this.bil2 = bilMin;
                                    while (this.bil2 <= bilMax) {
                                        this.ldhCat2 = ldhCatMin;
                                        while (this.ldhCat2 <= ldhCatMax) {
                                            this.priapism2 = priapismMin;
                                            while (this.priapism2 <= priapismMax) {
                                                this.pain2 = painMin;
                                                while (this.pain2 <= painMax) {
                                                    this.acs2 = acsMin;
                                                    while (this.acs2 <= acsMax) {
                                                        this.mcv2 = mcvMin;
                                                        while (this.mcv2 <= mcvMax) {
                                                            this.bTransf2 = bTransfMin;
                                                            while (this.bTransf2 <= bTransfMax) {
                                                                this.hemo2 = hemoMin;
                                                                while (this.hemo2 <= hemoMax) {
                                                                    this.avn2 = avnMin;
                                                                    while (this.avn2 <= avnMax) {
                                                                        risk += this.ComputeKnownRisk(death);
                                                                        ++this.avn2;
                                                                    }
                                                                    ++this.hemo2;
                                                                }
                                                                ++this.bTransf2;
                                                            }
                                                            ++this.mcv2;
                                                        }
                                                        ++this.acs2;
                                                    }
                                                    ++this.pain2;
                                                }
                                                ++this.priapism2;
                                            }
                                            ++this.ldhCat2;
                                        }
                                        ++this.bil2;
                                    }
                                    ++this.sysBpCat2;
                                }
                                ++this.stroke2;
                            }
                            ++this.sepsis2;
                        }
                        ++this.sex2;
                    }
                    ++this.ageCat2;
                }
                ++this.retic2;
            }
            ++this.wbcCat2;
        }
        return risk;
    }

    private double ComputeKnownRisk(int death) {
        double risk = 1.0;
        risk *= this.wbcCatP[death][this.wbcCat2];
        risk *= this.reticP[death][this.wbcCat2][this.retic2];
        risk *= this.bilP[this.retic2][this.bil2];
        risk *= this.hemoP[this.wbcCat2][this.bil2][this.retic2][this.hemo2];
        risk *= this.ldhCatP[this.retic2][this.bil2][this.ldhCat2];
        risk *= this.ageCatP[this.ldhCat2][this.bil2][death][this.ageCat2];
        risk *= this.priapismP[this.ageCat2][this.priapism2];
        risk *= this.sexP[death][this.priapism2][this.sex2];
        risk *= this.mcvP[this.retic2][this.ageCat2][this.hemo2][this.mcv2];
        risk *= this.acsP[this.retic2][this.acs2];
        risk *= this.avnP[this.acs2][this.ageCat2][this.retic2][this.avn2];
        risk *= this.painP[this.avn2][this.acs2][this.ageCat2][this.pain2];
        risk *= this.sepsisP[this.ageCat2][this.acs2][death][this.sepsis2];
        risk *= this.bTransfP[this.sepsis2][this.retic2][this.bTransf2];
        risk *= this.strokeP[this.mcv2][death][this.bTransf2][this.stroke2];
        return risk *= this.sysBpCatP[death][this.pain2][this.ageCat2][this.sysBpCat2];
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jOptionPane1 = new JOptionPane();
        this.panelNorte = new JPanel();
        this.titulo = new JLabel();
        this.panelCentral = new JPanel();
        this.ACS_label = new JLabel();
        this.Acs = new JComboBox();
        this.age_label = new JLabel();
        this.AgeCat = new JComboBox();
        this.bilirubin_label = new JLabel();
        this.Bil = new JComboBox();
        this.bloodTransfusion_label = new JLabel();
        this.BTransf = new JComboBox();
        this.LDH_label = new JLabel();
        this.LdhCat = new JComboBox();
        this.MCV_label = new JLabel();
        this.Mcv = new JComboBox();
        this.pain_label = new JLabel();
        this.Pain = new JComboBox();
        this.priapism_label = new JLabel();
        this.Priapism = new JComboBox();
        this.retic_label = new JLabel();
        this.Retic = new JComboBox();
        this.sepsis_label = new JLabel();
        this.Sepsis = new JComboBox();
        this.gender_label = new JLabel();
        this.Sex = new JComboBox();
        this.stroke_label = new JLabel();
        this.Stroke = new JComboBox();
        this.systolicBP_label = new JLabel();
        this.SysBpCat = new JComboBox();
        this.WBC_label = new JLabel();
        this.WbcCat = new JComboBox();
        this.hemoglobinGenotype_label = new JLabel();
        this.Hemo = new JComboBox();
        this.AVN_label = new JLabel();
        this.Avn = new JComboBox();
        this.panelSur = new JPanel();
        this.estimateRisk_button = new JButton();
        this.progress = new JLabel("Probability of death is: ", 4);
        this.resultLabel = new JLabel("----------", 0);
        this.jOptionPane1.setName("Gender change");
        this.panelNorte.setBackground(new Color(204, 153, 255));
        this.titulo.setFont(new Font("Tahoma", 1, 18));
        this.titulo.setLabelFor(this);
        this.titulo.setText("Sickle Cell Disease severity Calculator");
        this.titulo.setVerticalAlignment(1);
        this.titulo.setVerticalTextPosition(1);
        this.panelNorte.add(this.titulo);
        this.getContentPane().add((Component)this.panelNorte, "First");
        this.panelCentral.setBackground(new Color(204, 153, 255));
        this.panelCentral.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.panelCentral.setAlignmentY(this.panelNorte.getAlignmentY());
        this.panelCentral.setDebugGraphicsOptions(-1);
        this.panelCentral.setEnabled(false);
        this.panelCentral.setFocusable(false);
        this.panelCentral.setFont(new Font("Lucida Sans", 0, 12));
        this.panelCentral.setMinimumSize(new Dimension(500, 300));
        this.panelCentral.setPreferredSize(new Dimension(500, 300));
        this.panelCentral.setLayout(new GridBagLayout());
        this.ACS_label.setText("ACS");
        this.ACS_label.setAlignmentX(5.0f);
        this.ACS_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.ACS_label, gridBagConstraints);
        this.ACS_label.getAccessibleContext().setAccessibleName("relleno");
        this.ACS_label.getAccessibleContext().setAccessibleDescription("Acs");
        this.Acs.setModel(new DefaultComboBoxModel<String>(new String[]{"no", "yes", "non available"}));
        this.Acs.setMaximumSize(new Dimension(125, 25));
        this.Acs.setMinimumSize(new Dimension(111, 25));
        this.Acs.setPreferredSize(new Dimension(111, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.Acs, gridBagConstraints);
        this.age_label.setHorizontalAlignment(2);
        this.age_label.setText("Age");
        this.age_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.age_label, gridBagConstraints);
        this.AgeCat.setModel(new DefaultComboBoxModel<String>(new String[]{"below 18", "18 - 40", "above 40", "non available"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.AgeCat, gridBagConstraints);
        this.bilirubin_label.setHorizontalAlignment(2);
        this.bilirubin_label.setText("Bilirubin");
        this.bilirubin_label.setAlignmentX(0.5f);
        this.bilirubin_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.bilirubin_label.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.bilirubin_label, gridBagConstraints);
        this.Bil.setModel(new DefaultComboBoxModel<String>(new String[]{"below 1.3", "1.3 - 3.4", "> 3.4", "non available"}));
        this.Bil.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Classifier.this.BilActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.Bil, gridBagConstraints);
        this.bloodTransfusion_label.setHorizontalAlignment(2);
        this.bloodTransfusion_label.setText("Blood Transfusion");
        this.bloodTransfusion_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.bloodTransfusion_label.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.panelCentral.add((Component)this.bloodTransfusion_label, gridBagConstraints);
        this.BTransf.setModel(new DefaultComboBoxModel<String>(new String[]{"no", "yes", "non available"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.BTransf, gridBagConstraints);
        this.LDH_label.setText("LDH");
        this.LDH_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.LDH_label, gridBagConstraints);
        this.LdhCat.setModel(new DefaultComboBoxModel<String>(new String[]{"below 300", "300 - 600", "> 600", "non available"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.LdhCat, gridBagConstraints);
        this.MCV_label.setText("MCV");
        this.MCV_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.MCV_label, gridBagConstraints);
        this.Mcv.setModel(new DefaultComboBoxModel<String>(new String[]{"below 80", "80 - 98", "above 98", "non available"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.Mcv, gridBagConstraints);
        this.pain_label.setText("Pain");
        this.pain_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.pain_label, gridBagConstraints);
        this.Pain.setModel(new DefaultComboBoxModel<String>(new String[]{"no", "yes", "non available"}));
        this.Pain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Classifier.this.PainActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.Pain, gridBagConstraints);
        this.priapism_label.setHorizontalAlignment(2);
        this.priapism_label.setText("Priapism");
        this.priapism_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.priapism_label, gridBagConstraints);
        this.Priapism.setModel(new DefaultComboBoxModel<String>(new String[]{"no (male)", "yes (male)", "non applicable (female)", "non available"}));
        this.Priapism.setAlignmentX(5.0f);
        this.Priapism.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Classifier.this.PriapismActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.Priapism, gridBagConstraints);
        this.retic_label.setText("Retic");
        this.retic_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.retic_label, gridBagConstraints);
        this.Retic.setModel(new DefaultComboBoxModel<String>(new String[]{"below 4.8", "4.8 - 13", "above 13", "non available"}));
        this.Retic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Classifier.this.ReticActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.Retic, gridBagConstraints);
        this.sepsis_label.setText("Sepsis");
        this.sepsis_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.sepsis_label, gridBagConstraints);
        this.Sepsis.setModel(new DefaultComboBoxModel<String>(new String[]{"no", "yes", "non available"}));
        this.Sepsis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Classifier.this.SepsisActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.Sepsis, gridBagConstraints);
        this.gender_label.setText("Gender");
        this.gender_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.gender_label, gridBagConstraints);
        this.Sex.setMaximumRowCount(2);
        this.Sex.setModel(new DefaultComboBoxModel<String>(new String[]{"male", "female", "non available"}));
        this.Sex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Classifier.this.SexActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.Sex, gridBagConstraints);
        this.stroke_label.setText("Stroke");
        this.stroke_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.stroke_label, gridBagConstraints);
        this.Stroke.setModel(new DefaultComboBoxModel<String>(new String[]{"no", "yes", "non available"}));
        this.Stroke.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Classifier.this.StrokeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.Stroke, gridBagConstraints);
        this.systolicBP_label.setText("Systolic BP");
        this.systolicBP_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.systolicBP_label, gridBagConstraints);
        this.SysBpCat.setModel(new DefaultComboBoxModel<String>(new String[]{"below 80", "80 - 120 (for age <= 18), 80-140 (for age above 18)", "120 - 140 (for age <= 18), 140 - 160 (for age above 18)", "above 140 (for age <= 18), above 160 (for age above 18)", "non available"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.SysBpCat, gridBagConstraints);
        this.WBC_label.setText("WBC");
        this.WBC_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.WBC_label, gridBagConstraints);
        this.WbcCat.setModel(new DefaultComboBoxModel<String>(new String[]{"below 10.8", "10.8 - 13.5", "above 13.5", "non available"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.WbcCat, gridBagConstraints);
        this.hemoglobinGenotype_label.setHorizontalAlignment(2);
        this.hemoglobinGenotype_label.setText("Hemoglobin genotype");
        this.hemoglobinGenotype_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        this.panelCentral.add((Component)this.hemoglobinGenotype_label, gridBagConstraints);
        this.Hemo.setModel(new DefaultComboBoxModel<String>(new String[]{"SC", "SS*", "SS+alpha-Thal", "non available"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.Hemo, gridBagConstraints);
        this.AVN_label.setText("AVN");
        this.AVN_label.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.AVN_label, gridBagConstraints);
        this.Avn.setModel(new DefaultComboBoxModel<String>(new String[]{"no", "yes", "non available"}));
        this.Avn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Classifier.this.AvnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        this.panelCentral.add((Component)this.Avn, gridBagConstraints);
        this.getContentPane().add((Component)this.panelCentral, "Center");
        this.panelSur.setBackground(new Color(204, 153, 255));
        this.panelSur.setBorder(BorderFactory.createEmptyBorder(10, 20, 20, 20));
        this.panelSur.setLayout(new FlowLayout());
        this.estimateRisk_button.setBackground(new Color(204, 204, 255));
        this.estimateRisk_button.setText("<html>Estimate<p>Death Risk</html>");
        this.estimateRisk_button.setBorder(BorderFactory.createBevelBorder(0));
        this.estimateRisk_button.setHorizontalTextPosition(2);
        this.estimateRisk_button.setMaximumSize(new Dimension(200, 50));
        this.estimateRisk_button.setMinimumSize(new Dimension(200, 50));
        this.estimateRisk_button.setPreferredSize(new Dimension(200, 50));
        this.resultLabel.setBorder(new LineBorder(Color.gray, 4, true));
        this.resultLabel.setMaximumSize(new Dimension(100, 50));
        this.resultLabel.setMinimumSize(new Dimension(100, 50));
        this.resultLabel.setPreferredSize(new Dimension(100, 50));
        this.progress.setMaximumSize(new Dimension(300, 50));
        this.progress.setMinimumSize(new Dimension(300, 50));
        this.progress.setPreferredSize(new Dimension(300, 50));
        this.resultLabel.setForeground(Color.black);
        this.resultLabel.setOpaque(true);
        this.resultLabel.setBackground(new Color(204, 204, 255));
        this.panelSur.add(this.estimateRisk_button);
        this.panelSur.add(this.progress);
        this.panelSur.add(this.resultLabel);
        this.estimateRisk_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Classifier.this.computeDeathRisk(evt);
            }
        });
        this.getContentPane().add((Component)this.panelSur, "Last");
        this.bindingGroup.bind();
    }

    private void AvnActionPerformed(ActionEvent evt) {
    }

    private void PriapismActionPerformed(ActionEvent evt) {
        if (this.Priapism.getSelectedIndex() == 2 && this.Sex.getSelectedIndex() == 0) {
            JOptionPane.showMessageDialog(null, "Priapism option not allowed for males. Changed to default value (no). Please, change gender if needed.");
            this.Priapism.setSelectedIndex(0);
        } else if (this.Priapism.getSelectedIndex() <= 1 && this.Sex.getSelectedIndex() == 1) {
            JOptionPane.showMessageDialog(null, "Priapism option not allowed for females. Changed to non appicable. Please, change gender if needed.");
            this.Priapism.setSelectedIndex(2);
        }
    }

    private void BilActionPerformed(ActionEvent evt) {
    }

    private void StrokeActionPerformed(ActionEvent evt) {
    }

    private void SexActionPerformed(ActionEvent evt) {
        if (this.Priapism.getSelectedIndex() == 2 && this.Sex.getSelectedIndex() == 0) {
            this.Priapism.setSelectedIndex(0);
            JOptionPane.showMessageDialog(null, "Priapism has been set to \"no\". Please, change the value if needed.");
        } else if (this.Priapism.getSelectedIndex() <= 1 && this.Sex.getSelectedIndex() == 1) {
            this.Priapism.setSelectedIndex(2);
            JOptionPane.showMessageDialog(null, "Priapism has been set to \"non applicable (female)\". Please, change the value if needed.");
        }
    }

    private void SepsisActionPerformed(ActionEvent evt) {
    }

    private void ReticActionPerformed(ActionEvent evt) {
    }

    private void computeDeathRisk(ActionEvent evt) {
        double riskDeath = 1.0;
        double riskSurvive = 1.0;
        String sP = new String("Computing probabilities: ");
        this.progress.setText(sP);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.progress.setText(sP);
        this.acs = this.Acs.getSelectedIndex();
        this.ageCat = this.AgeCat.getSelectedIndex();
        this.bTransf = this.BTransf.getSelectedIndex();
        this.bil = this.Bil.getSelectedIndex();
        this.ldhCat = this.LdhCat.getSelectedIndex();
        this.mcv = this.Mcv.getSelectedIndex();
        this.pain = this.Pain.getSelectedIndex();
        this.priapism = this.Priapism.getSelectedIndex();
        this.retic = this.Retic.getSelectedIndex();
        this.sepsis = this.Sepsis.getSelectedIndex();
        int S = this.sex = this.Sex.getSelectedIndex();
        if (S == 0) {
            this.sex = 1;
        }
        if (S == 1) {
            this.sex = 0;
        }
        this.stroke = this.Stroke.getSelectedIndex();
        this.sysBpCat = this.SysBpCat.getSelectedIndex();
        this.wbcCat = this.WbcCat.getSelectedIndex();
        this.hemo = this.Hemo.getSelectedIndex();
        this.avn = this.Avn.getSelectedIndex();
        this.bTransf = this.BTransf.getSelectedIndex();
        riskDeath = this.computeRisk(1);
        riskSurvive = this.computeRisk(0);
        riskDeath /= riskDeath + riskSurvive;
        this.progress.setText("");
        this.setCursor(Cursor.getDefaultCursor());
        String s1 = Double.toString(riskDeath);
        s1 = s1.substring(0, s1.indexOf(46) + 6);
        String s = new String("Probability of death is: ");
        this.progress.setText(s);
        this.resultLabel.setForeground(Color.black);
        this.resultLabel.setText("  " + s1);
    }

    private void PainActionPerformed(ActionEvent evt) {
    }
}

