%iTDT function
% Input: SNP dataset, one row per individual, 7 + 2*TotalSNPs columns
% Description of columns:
% column 1: individual code 
% column 2: not used (it uses to be the family code)
% column 3: father code (0 if the individual is not a child)
% column 4: mother code (0 if the individual is not a child)
% column 5: gender (not used)
% column 6: affection status (not used)
% column 7: another individual id (not used)
% columns 8 until 7+2*TotalSNPs: SNPs values (each SNP uses two contiguous
% columns). Example: if SNP1 value for an individual is 12 (heterozygous),
% column8 will have the value 1 and column9 will have the 2.

% Output: table IntervalTDT, one column per SNP, then there will be
% TotalSNPs columns.
% 45 rows.
% Description of rows:
% rows 1 to 21: n1, n2, ..., n21
% rows 22 to 31: m1, m2, m3, ..., m10
% row 32: b  (=m3+m6+2m8+m9)
% row 33: c (=m4+m7+m9+2m10)
% row 34: b1 (=b+n9)
% row 35: c1 (=c+n11)
% row 36: bmax (=b+2n2+n3+n5+n6+2n8+2n9+n10+n12+n13+n15+2n16+n17) 
% row 37: cmax (=c+n3+2n4+n5+n7+2n8+n10+2n11+n12+n14+n15+2n16+n17)
% row 38: T(b,c)  (standard TDT)
% row 39: T(bM,c1)
% row 40: T (b1,cM)
% row 41: Tmin (if b1>cM then Tmin=T(b1,cM) else if bM<c1 then
% Tmin=T(bM,c1))
% else Tmin=0
% row 42: Tmax=max(T(bM,c1),T(b1,cM))
% row 43: pvalue T
% row 44: pvalue Tmin
% row 45: pvalue Tmax

function IntervalTDT = iTDT (SNP)

MayorAllele=GetMayorAllele (SNP);

IntervalTDT=zeros(45,(size(SNP,2)-7)/2);
    for SNPColumn=8:2:size(SNP,2)% for every SNP
     column=(SNPColumn-6)/2;
     fprintf ( 'Computing values for SNP %d\n', column); 
     for row=1:size(SNP,1)% for every individual
    %  row
   %  Incr(row,column) = 0; 
     
        if IsAChild (row,SNP)
          IntervalTDT=EnesTrios(row, SNPColumn, SNP, IntervalTDT, MayorAllele);   
          IntervalTDT=EmesTrios(row, SNPColumn, SNP, IntervalTDT, MayorAllele);   
      end
  end
  
  % row 32: b  (=m3+m6+2m8+m9)
     IntervalTDT(32,column)=IntervalTDT(24,column)+IntervalTDT(27,column)+2*IntervalTDT(29,column)+IntervalTDT(30,column);
  % row 33: c (=m4+m7+m9+2m10)
     IntervalTDT(33,column)=IntervalTDT(25,column)+IntervalTDT(28,column)+IntervalTDT(30,column)+2*IntervalTDT(31,column);
  % row 34: b1 (=b+n9)
     IntervalTDT(34,column)=IntervalTDT(32,column)+IntervalTDT(9,column);
  % row 35: c1 (=c+n11)
     IntervalTDT(35,column)=IntervalTDT(33,column)+IntervalTDT(11,column);
  % row 36: bmax (=b+2n2+n3+n5+n6+2n8+2n9+n10+n12+n13+n15+2n16+n17) 
     IntervalTDT(36,column)=IntervalTDT(32,column)+2*IntervalTDT(2,column)+IntervalTDT(3,column)+ ...
     IntervalTDT(5,column)+IntervalTDT(6,column)+2*IntervalTDT(8,column)+2*IntervalTDT(9,column)+ ...
     IntervalTDT(10,column)+IntervalTDT(12,column)+IntervalTDT(13,column)+ ...
     IntervalTDT(15,column)+2*IntervalTDT(16,column)+IntervalTDT(17,column);
 
  % row 37: cmax (=c+n3+2n4+n5+n7+2n8+n10+2n11+n12+n14+n15+2n16+n17)
     IntervalTDT(37,column)=IntervalTDT(33,column)+IntervalTDT(3,column)+2*IntervalTDT(4,column)+...
     IntervalTDT(5,column)+IntervalTDT(7,column)+2*IntervalTDT(8,column)+IntervalTDT(10,column)+...
     2*IntervalTDT(11,column)+IntervalTDT(12,column)+IntervalTDT(14,column)+...
     IntervalTDT(15,column)+2*IntervalTDT(16,column)+IntervalTDT(17,column);
  
  % row 38: T(b,c)  (standard TDT)
     IntervalTDT(38, column)=(IntervalTDT(32,column)-IntervalTDT(33,column))^2/(IntervalTDT(32,column)+IntervalTDT(33,column));

  % row 39: T(bM,c1)
     IntervalTDT(39, column)=(IntervalTDT(36,column)-IntervalTDT(35,column))^2/(IntervalTDT(36,column)+IntervalTDT(35,column));
     
  % row 40: T (b1,cM)
     IntervalTDT(40, column)=(IntervalTDT(34,column)-IntervalTDT(37,column))^2/(IntervalTDT(34,column)+IntervalTDT(37,column));

  % row 41: Tmin (if b1>cM then Tmin=T(b1,cM) else if bM<c1 then
  % Tmin=T(bM,c1)) else Tmin=0
     if IntervalTDT(34,column)>IntervalTDT(37,column) IntervalTDT(41,column)=IntervalTDT(40,column);
     elseif IntervalTDT(36,column)<IntervalTDT(35,column) IntervalTDT(41,column)=IntervalTDT(39,column);
     else IntervalTDT(41,column)=0;
     end
  % row 42: Tmax=max(T(bM,c1),T(b1,cM))
    IntervalTDT(42,column)=max(IntervalTDT(39,column),IntervalTDT(40,column));
  
   % row 43: pvalue T
    IntervalTDT(43,column)=1-Gammainc(IntervalTDT(38,column)/2,0.5);
    
   % row 44: pvalue Tmin
    IntervalTDT(44,column)=1-Gammainc(IntervalTDT(41,column)/2,0.5);
    
   % row 45: pvalue Tmax
    IntervalTDT(45,column)=1-Gammainc(IntervalTDT(42,column)/2,0.5);
          
   end
  end
  
end

