  /**
    * @file rTDT.cpp
    * @brief Program to resolve phase
    *
    */


//#include <genoma.h>
#include <iostream>
#include <cassert>
#include <fstream>

#include "rTDT.h"


//using namespace SNP;

     //typedef enum typefile {phase=0, TDT=1};

//	 typefile tf;


//using namespace std;
//using namespace string;

namespace SNP {

IndCategory ic;


/* _____________________________________________________*/

void rTDTf(char *filename, unsigned int TotalSNPs, unsigned int Size)
{

char * filename2;
//strcpy(filename2, filename);
rTDT *Sample;
if ((Sample = new rTDT(filename, TotalSNPs, Size))==NULL)
 throw NoMemory();

Sample->GetMajorAllele ((IndCategory)2);
Sample->GetMinorAllele ((IndCategory)2);


Sample->GetCompleteTrioFrequencies();
Sample->Getb(); 
Sample->Getc(); 
Sample->Gett(); 
Sample->Getp(); 
Sample->GetMissingTrioFrequencies();
Sample->Getb1(); 
Sample->Getc1(); 
Sample->Getbmax(); 
Sample->Getcmax(); 
Sample->Gettmin(); 
Sample->Gettmax(); 
Sample->Getpmin(); 
Sample->Getpmax(); 

filename2=strtok(filename, ".");

strncat(filename2, ".sal\0", 4);//
cout << "\nOutput file: " << filename2 <<"\n";

Sample->WriteResults(filename2);

}
}


/*****************/
/*          MAIN          */
/*****************/

using namespace SNP;


int main(int argc, char*argv[]) {

     if(argc!=4)
     {
        cerr << "Error: you have to especify the following information:" << endl;
        cerr  << argv[0] << " <fichero> " << " <#SNPs>" << " <#individuals>" << endl;
        exit(-1);
        }
     char* filename;
	 if ((filename=new char[64])==NULL)
		 throw NoMemory();
	 strcpy(filename, argv[1]);
     unsigned int TotalSNPs=atoi(argv[2]);
     unsigned int TotalIndividuals=atoi(argv[3]);

     try{                     
         rTDTf(filename, TotalSNPs, TotalIndividuals);
	}

	 catch (BadFile bf) {
		 bf.PrintMessage();}
	 catch (NoMemory nm) {
		 nm.PrintMessage();}
     catch (NullNode nn) {
		 nn.PrintMessage();}

   return 0;

}





